/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.internal.actions.copy;

import java.util.Collection;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.jface.action.Action;
import org.eclipse.sirius.business.api.dialect.command.CopyRepresentationCommand;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.common.ui.tools.api.dialog.RenameDialog;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;

public class CopyRepresentationAction
extends Action {
    final Session session;
    final Collection<DRepresentation> representations;

    public CopyRepresentationAction(Session session, Collection<DRepresentation> selection) {
        super("Copy");
        this.session = session;
        this.representations = selection;
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY"));
        this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY_DISABLED"));
    }

    public void run() {
        RenameDialog dialog;
        if (this.representations.size() == 1) {
            String oldName = this.getOldName();
            dialog = new RenameDialog(Display.getCurrent().getActiveShell(), oldName);
            dialog.create();
            dialog.setTitle("Enter the name for the copied representation");
        } else {
            String prefix = this.getPrefix();
            dialog = new RenameDialog(Display.getCurrent().getActiveShell(), prefix);
            dialog.create();
            dialog.setTitle("Enter the prefix for the copied representations name");
            dialog.setText("Copy of");
        }
        if (dialog.open() == 0) {
            String newName = dialog.getNewName();
            DRepresentation dRepresentation = this.representations.iterator().next();
            TransactionalEditingDomain transDomain = TransactionUtil.getEditingDomain((EObject)dRepresentation);
            transDomain.getCommandStack().execute((Command)new CopyRepresentationCommand(transDomain, this.representations, newName, this.session));
        }
    }

    private String getOldName() {
        DRepresentation representation = this.representations.iterator().next();
        return representation.getName() != null ? representation.getName() : "";
    }

    private String getPrefix() {
        return "";
    }
}

