/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.api.actions.export;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.common.tools.api.util.EclipseUtil;
import org.eclipse.sirius.common.tools.api.util.FileUtil;
import org.eclipse.sirius.ext.swt.ImageFileFormat;
import org.eclipse.sirius.ui.business.api.dialect.DialectUIManager;
import org.eclipse.sirius.ui.business.api.dialect.ExportFormat;
import org.eclipse.sirius.ui.tools.api.actions.export.IAfterExport;
import org.eclipse.sirius.ui.tools.api.actions.export.IAroundExport;
import org.eclipse.sirius.ui.tools.api.actions.export.IBeforeExport;
import org.eclipse.sirius.ui.tools.api.actions.export.SizeTooLargeException;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.SiriusPlugin;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class ExportAction
extends WorkspaceModifyOperation {
    public static final String EXPORT_DIAGRAMS_AS_IMAGES_ACTION_TITLE = "Export Diagrams as images";
    private static final String EXPORT_DIAGRAMS_AS_IMAGES_ACTION_CANCELLED = "The operation was cancelled";
    private static final String EXPORT_DIAGRAMS_AS_IMAGES_ACTION_DEFAULT_DIAGRAM_NAME = "DiagramWithoutName";
    private static final String EXPORT_DIAGRAMS_AS_IMAGES_ACTION_ERROR_ON_MEMORY_ALLOCATION = "Not enough memory available to create image files";
    private static final char POINT = '.';
    private Session session;
    private Collection<DRepresentation> dRepresentationsToExportAsImage;
    private IPath outputPath;
    private ImageFileFormat imageFormat;
    private boolean exportToHtml;

    public ExportAction(Session session, Collection<DRepresentation> dRepresentationsToExportAsImage, IPath outputPath, ImageFileFormat imageFormat, boolean exportToHtml) {
        this.session = session;
        this.dRepresentationsToExportAsImage = dRepresentationsToExportAsImage;
        this.outputPath = outputPath;
        this.imageFormat = imageFormat;
        this.exportToHtml = exportToHtml;
    }

    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        try {
            monitor.beginTask(EXPORT_DIAGRAMS_AS_IMAGES_ACTION_TITLE, 7);
            try {
                this.createImageFiles(monitor);
            }
            catch (OutOfMemoryError e) {
                this.handleException(e, EXPORT_DIAGRAMS_AS_IMAGES_ACTION_ERROR_ON_MEMORY_ALLOCATION);
            }
        }
        finally {
            monitor.done();
            if (monitor.isCanceled()) {
                throw new InterruptedException(EXPORT_DIAGRAMS_AS_IMAGES_ACTION_CANCELLED);
            }
        }
    }

    private void handleException(Throwable t, String title) {
        Shell shell = new Shell();
        MessageDialog.openError((Shell)shell, (String)title, (String)t.getMessage());
        shell.dispose();
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    protected void createImageFiles(IProgressMonitor monitor) {
        block20: {
            beforeContributors = EclipseUtil.getExtensionPlugins(IBeforeExport.class, (String)"org.eclipse.sirius.ui.exportRepresentationsAsImagesExtension", (String)"class");
            aroundContributors = EclipseUtil.getExtensionPlugins(IAroundExport.class, (String)"org.eclipse.sirius.ui.exportRepresentationsAsImagesExtension", (String)"class");
            afterContributors = EclipseUtil.getExtensionPlugins(IAfterExport.class, (String)"org.eclipse.sirius.ui.exportRepresentationsAsImagesExtension", (String)"class");
            exportFormat = new ExportFormat(this.exportToHtml != false ? ExportFormat.ExportDocumentFormat.HTML : ExportFormat.ExportDocumentFormat.NONE, this.imageFormat);
            imageFileExtension = exportFormat.getImageFormat().getName().toLowerCase();
            for (IBeforeExport iBeforeExport : beforeContributors) {
                iBeforeExport.beforeExportAction(this.dRepresentationsToExportAsImage, this.outputPath, imageFileExtension);
            }
            if (!aroundContributors.isEmpty()) {
                for (IAroundExport iAroundExport : aroundContributors) {
                    iAroundExport.aroundExportAction(this.dRepresentationsToExportAsImage, this.outputPath, imageFileExtension);
                }
            } else {
                errorDuringExport = false;
                messageException = new ArrayList<CoreException>();
                shell = Display.getCurrent().getActiveShell();
                try {
                    for (DRepresentation representation : this.dRepresentationsToExportAsImage) {
                        block19: {
                            if (this.outputPath.toFile().isDirectory()) {
                                filePath = this.getFilePath(this.outputPath, representation.getName(), imageFileExtension);
                            } else if (this.outputPath.getFileExtension() != null) {
                                imageFileExtensionLowerCase = this.outputPath.getFileExtension().toLowerCase();
                                filePath = this.outputPath.removeFileExtension().addFileExtension(imageFileExtensionLowerCase);
                            } else {
                                filePath = this.outputPath;
                            }
                            for (Object contributor : beforeContributors) {
                                contributor.beforeExportRepresentationAsImage((EObject)representation, filePath);
                            }
                            if (DialectUIManager.INSTANCE.canHandle(representation)) {
                                try {
                                    DialectUIManager.INSTANCE.export(representation, this.session, filePath, exportFormat, (IProgressMonitor)new SubProgressMonitor(monitor, 7));
                                }
                                catch (CoreException exception) {
                                    if (!(exception instanceof SizeTooLargeException)) break block19;
                                    errorDuringExport = true;
                                    messageException.add(exception);
                                }
                            }
                        }
                        for (Object contributor : afterContributors) {
                            contributor.afterExportRepresentationAsImage((EObject)representation, filePath);
                        }
                    }
                }
                finally {
                    if (!errorDuringExport) break block20;
                    messageExceptionForDialog = new StringBuffer();
                    messageExceptionForDialog.append("One or more representations could not be exported because they are too large: ");
                    ** for (thr : messageException)
                }
lbl-1000:
                // 1 sources

                {
                    messageExceptionForDialog.append("\n");
                    messageExceptionForDialog.append(" - ");
                    messageExceptionForDialog.append(thr.getMessage());
                    continue;
                }
lbl58:
                // 1 sources

                MessageDialog.openError((Shell)shell, (String)"Image export impossible", (String)messageExceptionForDialog.toString());
                SiriusPlugin.getDefault().error("Error while export representation to image", (Throwable)new SizeTooLargeException((IStatus)new Status(4, "org.eclipse.sirius", messageExceptionForDialog.toString())));
            }
        }
        for (IAfterExport iAfterExport : afterContributors) {
            iAfterExport.afterExportAction();
        }
    }

    private IPath getFilePath(IPath destinationFolder, String providedFilename, String extension) {
        IPath filePath;
        String filename = null;
        filename = providedFilename.length() == 0 ? new String(EXPORT_DIAGRAMS_AS_IMAGES_ACTION_DEFAULT_DIAGRAM_NAME) : providedFilename;
        StringBuffer file = new StringBuffer(filename).append('.').append(extension);
        String filenameWithExtension = this.validFilename(file.toString());
        if (destinationFolder.append(filenameWithExtension).toFile().exists()) {
            int version = 1;
            do {
                String newFileName = this.validFilename(new StringBuffer(filename).append('_').append(String.valueOf(version)).append('.').append(extension).toString());
                filePath = destinationFolder.append(newFileName);
                ++version;
            } while (filePath.toFile().exists());
        } else {
            filePath = destinationFolder.append(filenameWithExtension);
        }
        return filePath;
    }

    private String validFilename(String filename) {
        FileUtil util = new FileUtil(filename);
        if (util.isValid()) {
            return filename;
        }
        return util.getValidFilename();
    }
}

