/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.listeners;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.util.Collection;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.TriggerListener;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.emf.core.util.CrossReferenceAdapter;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.commands.wrappers.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.uml.diagram.common.util.DiagramEditPartsUtil;

public abstract class AbstractPapyrusModifcationTriggerListener
extends TriggerListener {
    protected Command trigger(TransactionalEditingDomain domain, Notification notification) {
        ICommand cc;
        if (notification != null && (cc = this.getModificationCommand(notification)) != null) {
            return new GMFtoEMFCommandWrapper(cc);
        }
        return null;
    }

    public abstract NotificationFilter getFilter();

    protected abstract ICommand getModificationCommand(Notification var1);

    protected IGraphicalEditPart getChildByEObject(EObject eObject, IGraphicalEditPart rootEditPart, boolean isEdge) {
        return DiagramEditPartsUtil.getChildByEObject(eObject, rootEditPart, isEdge);
    }

    protected Iterable<View> getReferencingView(EObject oldEObject, Predicate<? super View> ... predicates) {
        ECrossReferenceAdapter eCrossReferencer = CrossReferenceAdapter.getCrossReferenceAdapter((Notifier)oldEObject);
        Collection settings = eCrossReferencer.getInverseReferences(oldEObject, false);
        Predicate<EStructuralFeature.Setting> predicate = new Predicate<EStructuralFeature.Setting>(){

            public boolean apply(EStructuralFeature.Setting input) {
                EObject from = input.getEObject();
                return from instanceof View && NotationPackage.Literals.VIEW__ELEMENT.equals(input.getEStructuralFeature());
            }
        };
        Iterable referencingView = Iterables.filter((Iterable)settings, (Predicate)predicate);
        Iterable views = Iterables.transform((Iterable)referencingView, (Function)new Function<EStructuralFeature.Setting, View>(){

            public View apply(EStructuralFeature.Setting from) {
                return (View)from.getEObject();
            }
        });
        return Iterables.filter((Iterable)views, (Predicate)Predicates.and(predicates));
    }

    protected TransactionalEditingDomain getEditingDomain(Object o) {
        EditingDomain editingDomain = AdapterFactoryEditingDomain.getEditingDomainFor((Object)o);
        if (editingDomain instanceof TransactionalEditingDomain) {
            TransactionalEditingDomain transEditingDomain = (TransactionalEditingDomain)editingDomain;
            return transEditingDomain;
        }
        throw new RuntimeException("Enable to retreive editing domin from object");
    }
}

