/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.figure.node;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.StringTokenizer;
import org.eclipse.draw2d.AbstractLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.draw2d.ui.render.factory.RenderedImageFactory;
import org.eclipse.gmf.runtime.draw2d.ui.render.figures.ScalableImageFigure;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.papyrus.uml.diagram.common.Activator;
import org.eclipse.papyrus.uml.diagram.common.figure.layout.PropertiesCompartmentLayoutManager;
import org.eclipse.papyrus.uml.diagram.common.figure.node.IPapyrusNodeUMLElementFigure;
import org.eclipse.papyrus.uml.diagram.common.figure.node.PapyrusNodeFigure;
import org.eclipse.papyrus.uml.diagram.common.figure.node.StereotypePropertiesCompartment;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;

public class ShapeNamedElementFigure
extends PapyrusNodeFigure
implements IPapyrusNodeUMLElementFigure {
    protected Label label = null;
    protected String name = "";
    protected ScalableImageFigure scalableImageFigure = null;
    private RectangleFigure stereotypePropertiesContent;
    private RectangleFigure stereotypePropertiesBrace;
    protected Image originalimage;
    protected Image adaptedImage;
    protected int numerNode;

    public ShapeNamedElementFigure(Image image) {
        this.originalimage = image;
        this.label = new Label("");
        this.label.setIconAlignment(2);
        this.label.setTextAlignment(2);
        this.label.setIconTextGap(2);
        this.add((IFigure)this.label);
        if (image != null) {
            this.label.setIcon(image);
        }
        this.setLayoutManager((LayoutManager)new ShapeLayoutManager());
    }

    public ShapeNamedElementFigure() {
        this(null);
        this.setBorder(null);
    }

    public void setIcon(String path) throws MalformedURLException {
        this.originalimage = null;
        URL url = new URL(path);
        this.scalableImageFigure = new ScalableImageFigure(RenderedImageFactory.getInstance((URL)url), false, true, true);
        this.scalableImageFigure.setMaintainAspectRatio(false);
        this.add((IFigure)this.scalableImageFigure);
    }

    public void setIcon(Image image) {
        if (this.scalableImageFigure != null) {
            this.remove((IFigure)this.scalableImageFigure);
            this.scalableImageFigure = null;
        }
        this.originalimage = image;
        this.label.setIcon(this.originalimage);
    }

    @Override
    public void setStereotypeDisplay(String stereotypes, Image image) {
    }

    @Override
    public void setStereotypePropertiesInBrace(String stereotypeProperties) {
        if (stereotypeProperties == null) {
            if (this.stereotypePropertiesBrace != null) {
                this.remove((IFigure)this.stereotypePropertiesBrace);
                this.stereotypePropertiesBrace = null;
            }
            return;
        }
        if (this.stereotypePropertiesBrace == null) {
            this.createStereotypePropertiesBrace();
        }
        this.fillStereotypePropertiesInBrace(stereotypeProperties);
    }

    @Override
    public void setStereotypePropertiesInCompartment(String stereotypeProperties) {
        if (stereotypeProperties == null) {
            if (this.stereotypePropertiesContent != null) {
                this.remove((IFigure)this.stereotypePropertiesContent);
                this.stereotypePropertiesContent = null;
            }
            return;
        }
        if (this.stereotypePropertiesContent == null) {
            this.createStereotypePropertiesContent();
        }
        this.fillStereotypePropertiesInCompartment(stereotypeProperties);
    }

    @Override
    public Label getStereotypesLabel() {
        return null;
    }

    private void fillStereotypePropertiesInCompartment(String stereotypeProperties) {
        this.stereotypePropertiesContent.getChildren().clear();
        StringTokenizer stringTokenizer = new StringTokenizer(stereotypeProperties, ";");
        while (stringTokenizer.hasMoreElements()) {
            String tokenStereotype = stringTokenizer.nextToken();
            tokenStereotype = tokenStereotype.replace("#", "\n  ");
            tokenStereotype = tokenStereotype.replace("|", "\n  ");
            Label label = new Label(tokenStereotype);
            label.setLabelAlignment(1);
            label.setBorder(null);
            this.stereotypePropertiesContent.add((IFigure)label);
        }
    }

    private void fillStereotypePropertiesInBrace(String stereotypeProperties) {
        this.stereotypePropertiesBrace.getChildren().clear();
        Label label = new Label("{" + stereotypeProperties + "}");
        label.setLabelAlignment(2);
        label.setBorder(null);
        this.stereotypePropertiesBrace.add((IFigure)label);
    }

    protected int getStereotypePropertiesCompartmentPosition() {
        return 1;
    }

    protected void createStereotypePropertiesContent() {
        this.stereotypePropertiesContent = new StereotypePropertiesCompartment();
        this.stereotypePropertiesContent.setFill(false);
        this.stereotypePropertiesContent.setLineWidth(0);
        this.stereotypePropertiesContent.setBorder(null);
        this.stereotypePropertiesContent.setLayoutManager((LayoutManager)new PropertiesCompartmentLayoutManager());
        this.add((IFigure)this.stereotypePropertiesContent, this.getStereotypePropertiesCompartmentPosition());
    }

    protected void createStereotypePropertiesBrace() {
        this.stereotypePropertiesBrace = new StereotypePropertiesCompartment();
        this.stereotypePropertiesBrace.setFill(false);
        this.stereotypePropertiesBrace.setLineWidth(0);
        this.stereotypePropertiesBrace.setBorder(null);
        this.stereotypePropertiesBrace.setLayoutManager((LayoutManager)new PropertiesCompartmentLayoutManager());
        this.add((IFigure)this.stereotypePropertiesBrace, this.getStereotypePropertiesCompartmentPosition());
    }

    public class ShapeLayoutManager
    extends AbstractLayout {
        protected Dimension calculatePreferredSize(IFigure container, int hint, int hint2) {
            int minimumWith = 50;
            int minimumHeight = 50;
            return new Dimension(minimumWith, minimumHeight);
        }

        public void layout(IFigure container) {
            Dimension dim;
            Rectangle imageBound = new Rectangle(container.getBounds());
            Rectangle compartmentBound = new Rectangle(container.getBounds());
            if (ShapeNamedElementFigure.this.stereotypePropertiesContent != null && ShapeNamedElementFigure.this.stereotypePropertiesContent.getChildren().size() > 0) {
                dim = ShapeNamedElementFigure.this.stereotypePropertiesContent.getPreferredSize();
                imageBound.height -= dim.height;
                compartmentBound.y = compartmentBound.y + compartmentBound.height - dim.height;
                compartmentBound.height = dim.height;
                ShapeNamedElementFigure.this.stereotypePropertiesContent.setBounds(compartmentBound);
            }
            if (ShapeNamedElementFigure.this.stereotypePropertiesBrace != null && ShapeNamedElementFigure.this.stereotypePropertiesBrace.getChildren().size() > 0) {
                dim = ShapeNamedElementFigure.this.stereotypePropertiesBrace.getPreferredSize();
                imageBound.height -= dim.height;
                compartmentBound.y = compartmentBound.y + compartmentBound.height - dim.height;
                compartmentBound.height = dim.height;
                ShapeNamedElementFigure.this.stereotypePropertiesBrace.setBounds(compartmentBound);
            }
            if (ShapeNamedElementFigure.this.scalableImageFigure != null) {
                ShapeNamedElementFigure.this.scalableImageFigure.setBounds(imageBound);
            } else if (ShapeNamedElementFigure.this.originalimage != null) {
                ShapeNamedElementFigure.this.label.setBounds(imageBound);
                String key = "icon" + ((Object)((Object)this)).hashCode();
                ImageData imdata = null;
                imdata = (ImageData)ShapeNamedElementFigure.this.originalimage.getImageData().scaledTo(imageBound.width, imageBound.height).clone();
                Image imm = Activator.getDefault().getImageRegistry().get(key);
                if (imm == null) {
                    Activator.getDefault().getImageRegistry().put(key, ImageDescriptor.createFromImageData((ImageData)imdata));
                    imm = Activator.getDefault().getImageRegistry().get(key);
                } else {
                    Activator.getDefault().getImageRegistry().remove(key);
                    Activator.getDefault().getImageRegistry().put(key, ImageDescriptor.createFromImageData((ImageData)imdata));
                    imm = Activator.getDefault().getImageRegistry().get(key);
                }
                if (ShapeNamedElementFigure.this.adaptedImage != null) {
                    ShapeNamedElementFigure.this.adaptedImage.dispose();
                    ShapeNamedElementFigure.this.adaptedImage = null;
                }
                ShapeNamedElementFigure.this.adaptedImage = imm;
                ShapeNamedElementFigure.this.label.setIcon(ShapeNamedElementFigure.this.adaptedImage);
            }
        }
    }
}

