/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.editpolicies;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.editpolicies.GraphicalEditPolicy;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.commands.DeleteCommand;
import org.eclipse.gmf.runtime.diagram.core.listener.DiagramEventBroker;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.EditCommandRequestWrapper;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.notation.EObjectValueStyle;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.core.listenerservice.IPapyrusListener;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.GMFUnsafe;
import org.eclipse.papyrus.uml.diagram.common.Activator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.uml2.uml.Element;

public class CommentShapeForAppliedStereotypeEditPolicy
extends GraphicalEditPolicy
implements NotificationListener,
IPapyrusListener {
    public void notifyChanged(Notification notification) {
        int eventType;
        View commentNode = this.getView();
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)commentNode);
        if (this.getUMLElement() == null) {
            this.executeAppliedStereotypeCommentDeletion(domain, commentNode);
        }
        if ((eventType = notification.getEventType()) == 1 && notification.getFeature().equals(NotationPackage.eINSTANCE.getView_Visible()) && this.getView() != null && this.getvisibleAppliedStereotypeCompartment(commentNode, (EObject)this.getUMLElement()) == 0) {
            this.executeAppliedStereotypeCommentDeletion(domain, commentNode);
        }
    }

    protected Element getUMLElement() {
        if ((Element)this.getView().getElement() != null) {
            return (Element)this.getView().getElement();
        }
        if (this.getView().getNamedStyle(NotationPackage.eINSTANCE.getEObjectValueStyle(), "BASE_ELEMENT") != null) {
            EObjectValueStyle eObjectValueStyle = (EObjectValueStyle)this.getView().getNamedStyle(NotationPackage.eINSTANCE.getEObjectValueStyle(), "BASE_ELEMENT");
            return (Element)eObjectValueStyle.getEObjectValue();
        }
        return null;
    }

    public Command getCommand(Request request) {
        if (request instanceof EditCommandRequestWrapper && ((EditCommandRequestWrapper)request).getEditCommandRequest() instanceof DestroyElementRequest) {
            return UnexecutableCommand.INSTANCE;
        }
        return super.getCommand(request);
    }

    protected void executeAppliedStereotypeCommentDeletion(final TransactionalEditingDomain domain, final View commentNode) {
        if (commentNode != null) {
            Display.getCurrent().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (TransactionUtil.getEditingDomain((EObject)commentNode) == domain) {
                        DeleteCommand command = new DeleteCommand(commentNode);
                        try {
                            GMFUnsafe.write((TransactionalEditingDomain)domain, (ICommand)command);
                        }
                        catch (Exception e) {
                            Activator.log.error((Throwable)e);
                        }
                    }
                }
            });
        }
    }

    protected int getvisibleAppliedStereotypeCompartment(View view, EObject eobject) {
        int nbVisibleCompartment = 0;
        for (View subview : view.getChildren()) {
            if (!subview.isVisible()) continue;
            ++nbVisibleCompartment;
        }
        return nbVisibleCompartment;
    }

    public void activate() {
        View view = this.getView();
        if (view == null) {
            return;
        }
        this.getDiagramEventBroker().addNotificationListener((EObject)view, (NotificationListener)this);
    }

    public void deactivate() {
        View view = this.getView();
        if (view == null) {
            return;
        }
        this.getDiagramEventBroker().removeNotificationListener((EObject)view, (NotificationListener)this);
    }

    protected DiagramEventBroker getDiagramEventBroker() {
        TransactionalEditingDomain theEditingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        if (theEditingDomain != null) {
            return DiagramEventBroker.getInstance((TransactionalEditingDomain)theEditingDomain);
        }
        return null;
    }

    protected View getView() {
        return (View)this.getHost().getModel();
    }
}

