/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.editparts;

import org.eclipse.draw2d.IFigure;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ListCompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ResizableCompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.figures.ResizableCompartmentFigure;
import org.eclipse.gmf.runtime.notation.FontStyle;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.Style;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.papyrus.infra.gmfdiag.common.editpart.NodeEditPart;
import org.eclipse.papyrus.uml.diagram.common.editparts.IUMLEditPart;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.ApplyStereotypeEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.figure.node.AppliedStereotypeCompartmentFigure;
import org.eclipse.papyrus.uml.diagram.common.figure.node.IPapyrusNodeUMLElementFigure;
import org.eclipse.papyrus.uml.diagram.common.helper.ICompartmentLayoutHelper;
import org.eclipse.papyrus.uml.diagram.common.service.ApplyStereotypeRequest;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.uml2.uml.Element;

public abstract class UMLNodeEditPart
extends NodeEditPart
implements IUMLEditPart {
    private FontDescriptor cachedFontDescriptor;
    private ICompartmentLayoutHelper compartmentLayoutHelper;

    protected ICompartmentLayoutHelper getCompartmentLayoutHelper() {
        return this.compartmentLayoutHelper;
    }

    protected void setCompartmentLayoutHelper(ICompartmentLayoutHelper compartmentLayoutHelper) {
        this.compartmentLayoutHelper = compartmentLayoutHelper;
    }

    public UMLNodeEditPart(View view) {
        super(view);
    }

    public void refresh() {
        super.refresh();
        this.changeLayoutCompartment();
        this.fixCompartmentTitleVisibility();
    }

    @Override
    public Element getUMLElement() {
        return (Element)this.resolveSemanticElement();
    }

    public void setLayoutConstraint(EditPart child, IFigure childFigure, Object constraint) {
        if (!(childFigure instanceof AppliedStereotypeCompartmentFigure)) {
            this.getContentPaneFor((IGraphicalEditPart)child).setConstraint(childFigure, constraint);
        }
    }

    protected void handleNotificationEvent(Notification event) {
        super.handleNotificationEvent(event);
        if (event.getNotifier() instanceof EAnnotation && "layoutFigure".equals(((EAnnotation)event.getNotifier()).getSource())) {
            this.changeLayoutCompartment();
        }
        Object feature = event.getFeature();
        if (NotationPackage.eINSTANCE.getFontStyle_FontColor().equals(feature)) {
            this.refreshFontColor();
        }
    }

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy(ApplyStereotypeRequest.APPLY_STEREOTYPE_REQUEST, (EditPolicy)new ApplyStereotypeEditPolicy());
    }

    protected void changeLayoutCompartment() {
        if (this.getCompartmentLayoutHelper() != null) {
            for (EditPart currentEditPart : this.getChildren()) {
                if (!(currentEditPart instanceof ListCompartmentEditPart)) continue;
                this.getCompartmentLayoutHelper().applyLayout((AbstractGraphicalEditPart)((ListCompartmentEditPart)currentEditPart));
            }
        }
    }

    public void fixCompartmentTitleVisibility() {
        for (Object currentEditPart : this.getChildren()) {
            ResizableCompartmentEditPart rcep;
            View compartmentView;
            Style titleStyle;
            if (!(currentEditPart instanceof ResizableCompartmentEditPart) || (titleStyle = (compartmentView = (View)(rcep = (ResizableCompartmentEditPart)currentEditPart).getModel()).getStyle(NotationPackage.eINSTANCE.getTitleStyle())) != null || !(rcep.getFigure() instanceof ResizableCompartmentFigure)) continue;
            ResizableCompartmentFigure rcf = (ResizableCompartmentFigure)rcep.getFigure();
            rcf.setTitleVisibility(false);
        }
    }

    public EditPart getTargetEditPart(Request request) {
        if (ApplyStereotypeRequest.APPLY_STEREOTYPE_REQUEST.equals(request.getType())) {
            return this;
        }
        return super.getTargetEditPart(request);
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        this.refreshShadow();
        this.refreshFontColor();
    }

    protected void refreshFont() {
        FontStyle style = (FontStyle)this.getPrimaryView().getStyle(NotationPackage.Literals.FONT_STYLE);
        if (style != null) {
            FontDescriptor fontDescriptor = FontDescriptor.createFrom((FontData)this.getFontData(style));
            Font newFont = this.getResourceManager().createFont(fontDescriptor);
            this.refreshLabelsFont(newFont);
            if (this.cachedFontDescriptor != null) {
                this.getResourceManager().destroyFont(this.cachedFontDescriptor);
            }
            this.cachedFontDescriptor = fontDescriptor;
        }
    }

    protected void refreshLabelsFont(Font font) {
        if (((IPapyrusNodeUMLElementFigure)this.getPrimaryShape()).getStereotypesLabel() != null) {
            ((IPapyrusNodeUMLElementFigure)this.getPrimaryShape()).getStereotypesLabel().setFont(font);
        }
    }

    protected FontData getFontData(FontStyle style) {
        return new FontData(style.getFontName(), style.getFontHeight(), (style.isBold() ? 1 : 0) | (style.isItalic() ? 2 : 0));
    }

    protected void setFontColor(Color color) {
        super.setFontColor(color);
        if (((IPapyrusNodeUMLElementFigure)this.getPrimaryShape()).getStereotypesLabel() != null) {
            ((IPapyrusNodeUMLElementFigure)this.getPrimaryShape()).getStereotypesLabel().setForegroundColor(color);
        }
    }
}

