/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.editparts;

import org.eclipse.draw2d.Label;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.emf.appearance.helper.NameLabelIconHelper;
import org.eclipse.papyrus.uml.diagram.common.editparts.BorderUMLNodeEditPart;
import org.eclipse.papyrus.uml.diagram.common.editparts.IUMLNamedElementEditPart;
import org.eclipse.papyrus.uml.diagram.common.figure.node.IPapyrusNodeNamedElementFigure;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.uml2.uml.NamedElement;

public abstract class BorderNamedElementEditPart
extends BorderUMLNodeEditPart
implements IUMLNamedElementEditPart {
    public BorderNamedElementEditPart(View view) {
        super(view);
    }

    @Override
    public NamedElement getNamedElement() {
        return (NamedElement)this.getUMLElement();
    }

    @Override
    protected void handleNotificationEvent(Notification event) {
        super.handleNotificationEvent(event);
        if (this.resolveSemanticElement() != null) {
            this.refreshIconNamedLabel();
            this.refreshFontColor();
        }
    }

    private void refreshIconNamedLabel() {
        this.getNodeNamedElementFigure().setNameLabelIcon(NameLabelIconHelper.showLabelIcon((EModelElement)((View)this.getModel())));
    }

    @Override
    protected void refreshVisuals() {
        super.refreshVisuals();
        if (this.getNodeNamedElementFigure() != null && this.resolveSemanticElement() != null) {
            this.refreshIconNamedLabel();
            this.refreshFontColor();
        }
        this.refreshBounds();
    }

    @Override
    protected void refreshLabelsFont(Font font) {
        Label tagLabel;
        super.refreshLabelsFont(font);
        this.getNodeNamedElementFigure().getNameLabel().setFont(font);
        Label qualifiedNameLabel = this.getNodeNamedElementFigure().getQualifiedNameLabel();
        if (qualifiedNameLabel != null) {
            qualifiedNameLabel.setFont(font);
        }
        if ((tagLabel = this.getNodeNamedElementFigure().getTaggedLabel()) != null) {
            tagLabel.setFont(font);
        }
    }

    private IPapyrusNodeNamedElementFigure getNodeNamedElementFigure() {
        return (IPapyrusNodeNamedElementFigure)this.getPrimaryShape();
    }

    @Override
    protected void setFontColor(Color color) {
        Label tagLabel;
        super.setFontColor(color);
        Label qualifiedNameLabel = this.getNodeNamedElementFigure().getQualifiedNameLabel();
        if (qualifiedNameLabel != null) {
            qualifiedNameLabel.setForegroundColor(color);
        }
        if ((tagLabel = this.getNodeNamedElementFigure().getTaggedLabel()) != null) {
            tagLabel.setForegroundColor(color);
        }
    }
}

