/*
 * Decompiled with CFR 0.152.
 */
package org.yakindu.sct.model.stext.stext;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum TimeUnit implements Enumerator
{
    SECOND(0, "second", "s"),
    MILLISECOND(1, "millisecond", "ms"),
    MICROSECOND(2, "microsecond", "us"),
    NANOSECOND(3, "nanosecond", "ns");

    public static final int SECOND_VALUE = 0;
    public static final int MILLISECOND_VALUE = 1;
    public static final int MICROSECOND_VALUE = 2;
    public static final int NANOSECOND_VALUE = 3;
    private static final TimeUnit[] VALUES_ARRAY;
    public static final List<TimeUnit> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new TimeUnit[]{SECOND, MILLISECOND, MICROSECOND, NANOSECOND};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static TimeUnit get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TimeUnit result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TimeUnit getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TimeUnit result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TimeUnit get(int value) {
        switch (value) {
            case 0: {
                return SECOND;
            }
            case 1: {
                return MILLISECOND;
            }
            case 2: {
                return MICROSECOND;
            }
            case 3: {
                return NANOSECOND;
            }
        }
        return null;
    }

    private TimeUnit(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

