/*
 * Decompiled with CFR 0.152.
 */
package org.yakindu.sct.model.stext.conversion;

import org.eclipse.xtext.conversion.ValueConverterException;
import org.eclipse.xtext.conversion.impl.AbstractLexerBasedConverter;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.util.Strings;

public class HexValueConverter
extends AbstractLexerBasedConverter<Integer> {
    public static final String HEX_PREFIX = "0x";

    public Integer toValue(String string, INode node) {
        if (Strings.isEmpty((String)string)) {
            throw new ValueConverterException("Couldn't convert empty string to number.", node, null);
        }
        try {
            return Integer.parseInt(string.substring(2), 16);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ValueConverterException("Couldn't convert '" + string + "' to number.", node, null);
        }
    }

    protected String toEscapedString(Integer value) {
        if (value < 0) {
            return "-0x" + Integer.toString(value * -1, 16).toUpperCase();
        }
        return HEX_PREFIX + Integer.toString(value, 16).toUpperCase();
    }
}

