/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tree.ui.tools.internal.editor;

import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.tree.ui.tools.internal.editor.listeners.DTreeItemExpansionChecker;
import org.eclipse.sirius.ui.tools.internal.editor.AbstractDTreeViewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TreeItem;

public class DTreeViewer
extends AbstractDTreeViewer {
    private DTreeItemExpansionChecker dTreeItemExpansionChecker;

    public DTreeViewer(Composite parent, int style, Session session) {
        super(parent, style);
        this.dTreeItemExpansionChecker.setPermissionAuthority(session.getModelAccessor().getPermissionAuthority());
    }

    protected void hookControl(Control control) {
        this.dTreeItemExpansionChecker = new DTreeItemExpansionChecker(control);
        super.hookControl(control);
    }

    public void expandToLevel(Object elementOrTreePath, int level) {
        int newLevel = level;
        if (level == -1) {
            newLevel = this.getCurrentExpandedLevel() + 1;
        }
        super.expandToLevel(elementOrTreePath, newLevel);
    }

    private int getCurrentExpandedLevel() {
        int maxLevel = 0;
        TreeItem[] treeItemArray = this.getTree().getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem child = treeItemArray[n2];
            int childValue = this.doBrowse(child, 1);
            if (childValue > maxLevel) {
                maxLevel = childValue;
            }
            ++n2;
        }
        return maxLevel;
    }

    private int doBrowse(TreeItem cur, int currentLevel) {
        int maxLevel = currentLevel;
        TreeItem[] treeItemArray = cur.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem child = treeItemArray[n2];
            int childValue = this.doBrowse(child, currentLevel + 1);
            if (childValue > maxLevel) {
                maxLevel = childValue;
            }
            ++n2;
        }
        return maxLevel;
    }

    protected void handleDispose(DisposeEvent event) {
        this.dTreeItemExpansionChecker.dispose();
        super.handleDispose(event);
    }
}

