/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.domain.values.impl;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.evaluation.DomainException;
import org.eclipse.ocl.examples.domain.ids.OclVoidTypeId;
import org.eclipse.ocl.examples.domain.ids.TuplePartId;
import org.eclipse.ocl.examples.domain.ids.TupleTypeId;
import org.eclipse.ocl.examples.domain.messages.EvaluatorMessages;
import org.eclipse.ocl.examples.domain.types.IdResolver;
import org.eclipse.ocl.examples.domain.values.BagValue;
import org.eclipse.ocl.examples.domain.values.CollectionValue;
import org.eclipse.ocl.examples.domain.values.IntegerValue;
import org.eclipse.ocl.examples.domain.values.NullValue;
import org.eclipse.ocl.examples.domain.values.ObjectValue;
import org.eclipse.ocl.examples.domain.values.OrderedCollectionValue;
import org.eclipse.ocl.examples.domain.values.OrderedSetValue;
import org.eclipse.ocl.examples.domain.values.RealValue;
import org.eclipse.ocl.examples.domain.values.SequenceValue;
import org.eclipse.ocl.examples.domain.values.SetValue;
import org.eclipse.ocl.examples.domain.values.TupleValue;
import org.eclipse.ocl.examples.domain.values.UniqueCollectionValue;
import org.eclipse.ocl.examples.domain.values.UnlimitedValue;
import org.eclipse.ocl.examples.domain.values.Value;
import org.eclipse.ocl.examples.domain.values.impl.InvalidValueException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UndefinedValueImpl
extends DomainException
implements NullValue {
    private static final long serialVersionUID = 1L;

    protected UndefinedValueImpl(@Nullable String message, @Nullable Throwable cause) {
        super(message, cause);
    }

    @Override
    @NonNull
    public NullValue abs() {
        return this.toInvalidValue();
    }

    @Override
    @NonNull
    public NullValue addInteger(@NonNull IntegerValue right) {
        return this.toInvalidValue();
    }

    @Override
    @NonNull
    public NullValue addReal(@NonNull RealValue right) {
        return this.toInvalidValue();
    }

    @Override
    @NonNull
    public OrderedCollectionValue append(@Nullable Object object) {
        return this.toInvalidValue();
    }

    @Override
    @NonNull
    public OrderedCollectionValue appendAll(@NonNull OrderedCollectionValue objects) {
        return this.toInvalidValue();
    }

    @Override
    @NonNull
    public BagValue asBagValue() {
        throw new InvalidValueException(EvaluatorMessages.TypedValueRequired, "Bag", this.getTypeName());
    }

    @NonNull
    public Collection<Object> asCollection() {
        throw new InvalidValueException("Collection value required", new Object[0]);
    }

    @Override
    @NonNull
    public CollectionValue asCollectionValue() {
        throw new InvalidValueException(EvaluatorMessages.TypedValueRequired, "Collection", this.getTypeName());
    }

    @Override
    @NonNull
    public Double asDouble() {
        throw new InvalidValueException(EvaluatorMessages.TypedValueRequired, "Double", this.getTypeName());
    }

    @Override
    @NonNull
    public <T> List<T> asEcoreObjects(@NonNull IdResolver idResolver, @NonNull Class<T> elementClass) {
        throw new InvalidValueException(this, "asEcoreObjects");
    }

    @Override
    @NonNull
    public Integer asInteger() {
        throw new InvalidValueException(EvaluatorMessages.TypedValueRequired, "Integer", this.getTypeName());
    }

    @Override
    @NonNull
    public IntegerValue asIntegerValue() {
        throw new InvalidValueException(EvaluatorMessages.TypedValueRequired, "Integer", this.getTypeName());
    }

    @NonNull
    public List<Object> asList() {
        throw new InvalidValueException("List value required", new Object[0]);
    }

    @Override
    @NonNull
    public EObject asNavigableObject() {
        throw new InvalidValueException(EvaluatorMessages.TypedValueRequired, "Object", this.getTypeName());
    }

    @Override
    @NonNull
    public Number asNumber() {
        throw new InvalidValueException("undefined value has no Number value", new Object[0]);
    }

    @Override
    @NonNull
    public Object asObject() {
        return this.toInvalidValue();
    }

    @Override
    @NonNull
    public ObjectValue asObjectValue() {
        throw new InvalidValueException(EvaluatorMessages.TypedValueRequired, "Object", this.getTypeName());
    }

    @Override
    @NonNull
    public OrderedCollectionValue asOrderedCollectionValue() {
        throw new InvalidValueException(EvaluatorMessages.TypedValueRequired, "OrderedCollection", this.getTypeName());
    }

    @Override
    @NonNull
    public OrderedSetValue asOrderedSetValue() {
        throw new InvalidValueException(EvaluatorMessages.TypedValueRequired, "OrderedSet", this.getTypeName());
    }

    @Override
    @NonNull
    public RealValue asRealValue() {
        throw new InvalidValueException(EvaluatorMessages.TypedValueRequired, "Real", this.getTypeName());
    }

    @Override
    @NonNull
    public SequenceValue asSequenceValue() {
        throw new InvalidValueException(EvaluatorMessages.TypedValueRequired, "Sequence", this.getTypeName());
    }

    @Override
    @NonNull
    public SetValue asSetValue() {
        throw new InvalidValueException(EvaluatorMessages.TypedValueRequired, "Set", this.getTypeName());
    }

    @Override
    @NonNull
    public TupleValue asTupleValue() {
        throw new InvalidValueException(EvaluatorMessages.TypedValueRequired, "Tuple", this.getTypeName());
    }

    @Override
    @NonNull
    public UniqueCollectionValue asUniqueCollectionValue() {
        throw new InvalidValueException(EvaluatorMessages.TypedValueRequired, "Unique Collection", this.getTypeName());
    }

    @Override
    @NonNull
    public Value asUnlimitedNaturalValue() {
        throw new InvalidValueException(EvaluatorMessages.TypedValueRequired, "UnlimitedNatural", this.getTypeName());
    }

    @Override
    @Nullable
    public Value at(int index) {
        return this.toInvalidValue();
    }

    @Override
    @NonNull
    public BigDecimal bigDecimalValue() {
        throw new InvalidValueException("undefined value has no BigDecimal value", new Object[0]);
    }

    @Override
    @NonNull
    public BigInteger bigIntegerValue() {
        throw new InvalidValueException("undefined value has no BigInteger value", new Object[0]);
    }

    @Override
    @NonNull
    public RealValue commutatedAdd(@NonNull RealValue left) {
        return this.toInvalidValue();
    }

    @Override
    @NonNull
    public IntegerValue commutatedDiv(@NonNull IntegerValue left) {
        return this.toInvalidValue();
    }

    @Override
    @NonNull
    public RealValue commutatedDivide(@NonNull RealValue left) {
        return this.toInvalidValue();
    }

    @Override
    @NonNull
    public IntegerValue commutatedMod(@NonNull IntegerValue left) {
        return this.toInvalidValue();
    }

    @Override
    @NonNull
    public RealValue commutatedMultiply(@NonNull RealValue left) {
        return this.toInvalidValue();
    }

    @Override
    @NonNull
    public RealValue commutatedSubtract(@NonNull RealValue left) {
        return this.toInvalidValue();
    }

    @Override
    public int compareTo(RealValue o) {
        throw new UnsupportedOperationException("UndefinedValueImpl.compareTo");
    }

    @Override
    public int compareToInteger(@NonNull IntegerValue right) {
        throw new UnsupportedOperationException("UndefinedValueImpl.compareTo");
    }

    @Override
    public int compareToReal(@NonNull RealValue right) {
        throw new UnsupportedOperationException("UndefinedValueImpl.compareTo");
    }

    @Override
    public int compareToUnlimited(@NonNull UnlimitedValue right) {
        throw new UnsupportedOperationException("UndefinedValueImpl.compareTo");
    }

    @Override
    @NonNull
    public IntegerValue count(@Nullable Object value) {
        return this.toInvalidValue();
    }

    @NonNull
    public CollectionValue createNew() {
        return this.toInvalidValue();
    }

    @NonNull
    public NullValue div(@NonNull IntegerValue right) {
        return this.toInvalidValue();
    }

    @Override
    @NonNull
    public NullValue divInteger(@NonNull IntegerValue right) {
        return this.toInvalidValue();
    }

    @Override
    @NonNull
    public NullValue divUnlimited(@NonNull UnlimitedValue right) {
        return this.toInvalidValue();
    }

    @Override
    @NonNull
    public RealValue divideInteger(@NonNull IntegerValue right) {
        return this.toInvalidValue();
    }

    @Override
    @NonNull
    public NullValue divideReal(@NonNull RealValue right) {
        return this.toInvalidValue();
    }

    @Override
    public double doubleValue() {
        throw new UnsupportedOperationException("InvalidValue.compareTo");
    }

    @Override
    @NonNull
    public Boolean excludes(@Nullable Object value) {
        throw new InvalidValueException(EvaluatorMessages.ConvertibleValueRequired, "Invalid");
    }

    @Override
    @NonNull
    public Boolean excludesAll(@NonNull CollectionValue c) {
        throw new InvalidValueException(EvaluatorMessages.ConvertibleValueRequired, "Invalid");
    }

    @Override
    @NonNull
    public CollectionValue excluding(@Nullable Object value) {
        return this.toInvalidValue();
    }

    @Override
    @NonNull
    public CollectionValue excludingAll(@NonNull CollectionValue c) {
        return this.toInvalidValue();
    }

    @Override
    @Nullable
    public Value first() {
        return this.toInvalidValue();
    }

    @Override
    @NonNull
    public CollectionValue flatten() {
        return this.toInvalidValue();
    }

    @Override
    public boolean flatten(@NonNull Collection<Object> flattenedElements) {
        return false;
    }

    @Override
    @NonNull
    public NullValue floor() {
        return this.toInvalidValue();
    }

    public DomainType getElement() {
        return null;
    }

    @NonNull
    public List<? extends Object> getElements() {
        throw new InvalidValueException("bad getElements()", new Object[0]);
    }

    @NonNull
    public DomainType getInstanceType() {
        throw new InvalidValueException("undefined value has no instance type", new Object[0]);
    }

    @Override
    public String getKind() {
        return "Collection";
    }

    @Override
    public Object getObject() {
        return null;
    }

    @Override
    @NonNull
    public abstract OclVoidTypeId getTypeId();

    @NonNull
    public String getTypeName() {
        return this.getTypeId().getDisplayName();
    }

    @Override
    @NonNull
    public Value getValue(@NonNull TuplePartId partId) {
        return this.toInvalidValue();
    }

    @Override
    @NonNull
    public Object getValue(int index) {
        return this.toInvalidValue();
    }

    @Override
    @NonNull
    public Boolean includes(@Nullable Object value) {
        throw new InvalidValueException(EvaluatorMessages.ConvertibleValueRequired, "Invalid");
    }

    @Override
    @NonNull
    public Boolean includesAll(@NonNull CollectionValue c) {
        throw new InvalidValueException(EvaluatorMessages.ConvertibleValueRequired, "Invalid");
    }

    @Override
    @NonNull
    public CollectionValue including(@Nullable Object value) {
        return this.toInvalidValue();
    }

    @Override
    @NonNull
    public CollectionValue includingAll(@NonNull CollectionValue c) {
        return this.toInvalidValue();
    }

    @Override
    @NonNull
    public IntegerValue indexOf(@Nullable Object object) {
        return this.toInvalidValue();
    }

    @Override
    @NonNull
    public SequenceValue insertAt(int index, @Nullable Object object) {
        return this.toInvalidValue();
    }

    @Override
    public int intSize() {
        return 0;
    }

    @Override
    @NonNull
    public CollectionValue intersection(@NonNull CollectionValue c) {
        return this.toInvalidValue();
    }

    @Override
    @NonNull
    public Boolean isEmpty() {
        throw new InvalidValueException(EvaluatorMessages.ConvertibleValueRequired, "Invalid");
    }

    public boolean isFalse() {
        return false;
    }

    @Override
    @Nullable
    public IntegerValue isIntegerValue() {
        return null;
    }

    @Override
    public boolean isOrdered() {
        return false;
    }

    public boolean isTrue() {
        return false;
    }

    @Override
    public boolean isUndefined() {
        return true;
    }

    @Override
    public boolean isUnique() {
        return false;
    }

    @Override
    public boolean isUnlimited() {
        return false;
    }

    @Override
    public boolean isUnlimitedNatural() {
        return false;
    }

    @Override
    @NonNull
    public Iterable<? extends Object> iterable() {
        return Collections.emptyList();
    }

    @NonNull
    public Iterator iterator() {
        return new Iterator();
    }

    @Override
    @Nullable
    public Value last() {
        return this.toInvalidValue();
    }

    @Override
    @NonNull
    public NullValue max(@NonNull RealValue right) {
        return this.toInvalidValue();
    }

    @Override
    @NonNull
    public NullValue maxInteger(@NonNull IntegerValue right) {
        return this.toInvalidValue();
    }

    @Override
    @NonNull
    public NullValue maxReal(@NonNull RealValue right) {
        return this.toInvalidValue();
    }

    @Override
    @NonNull
    public NullValue maxUnlimited(@NonNull UnlimitedValue right) {
        return this.toInvalidValue();
    }

    @Override
    @NonNull
    public NullValue min(@NonNull RealValue right) {
        return this.toInvalidValue();
    }

    @Override
    @NonNull
    public NullValue minInteger(@NonNull IntegerValue right) {
        return this.toInvalidValue();
    }

    @Override
    @NonNull
    public NullValue minReal(@NonNull RealValue right) {
        return this.toInvalidValue();
    }

    @Override
    @NonNull
    public NullValue minUnlimited(@NonNull UnlimitedValue right) {
        return this.toInvalidValue();
    }

    @Override
    @NonNull
    public NullValue minus(@NonNull UniqueCollectionValue set) {
        return this.toInvalidValue();
    }

    @Override
    @NonNull
    public NullValue modInteger(@NonNull IntegerValue right) {
        return this.toInvalidValue();
    }

    @Override
    @NonNull
    public NullValue modUnlimited(@NonNull UnlimitedValue right) {
        return this.toInvalidValue();
    }

    @Override
    @NonNull
    public NullValue multiplyInteger(@NonNull IntegerValue right) {
        return this.toInvalidValue();
    }

    @Override
    @NonNull
    public NullValue multiplyReal(@NonNull RealValue right) {
        return this.toInvalidValue();
    }

    @Override
    @NonNull
    public NullValue negate() {
        return this.toInvalidValue();
    }

    @Override
    @NonNull
    public Boolean notEmpty() {
        throw new InvalidValueException(EvaluatorMessages.ConvertibleValueRequired, "Invalid");
    }

    @Override
    @NonNull
    public OrderedCollectionValue prepend(@Nullable Object object) {
        return this.toInvalidValue();
    }

    @Override
    @NonNull
    public OrderedCollectionValue prependAll(@NonNull OrderedCollectionValue objects) {
        return this.toInvalidValue();
    }

    @Override
    @Nullable
    public Set<TupleValue> product(@NonNull CollectionValue c, @NonNull TupleTypeId tupleTypeId) {
        return null;
    }

    @Override
    @NonNull
    public OrderedCollectionValue reverse() {
        return this.toInvalidValue();
    }

    @Override
    @NonNull
    public NullValue round() {
        return this.toInvalidValue();
    }

    @Override
    public int signum() {
        throw new UnsupportedOperationException("InvalidValue.compareTo");
    }

    @Override
    @NonNull
    public IntegerValue size() {
        return this.toInvalidValue();
    }

    @Override
    @NonNull
    public SequenceValue sort(@NonNull Comparator<Object> comparator) {
        return this.toInvalidValue();
    }

    @NonNull
    public String stringValue() {
        throw new InvalidValueException("undefined value has no String value", new Object[0]);
    }

    @Override
    @NonNull
    public NullValue subOrderedSet(int lower, int upper) {
        return this.toInvalidValue();
    }

    @Override
    @NonNull
    public NullValue subSequence(int lower, int upper) {
        return this.toInvalidValue();
    }

    @Override
    @NonNull
    public NullValue subtractInteger(@NonNull IntegerValue right) {
        return this.toInvalidValue();
    }

    @Override
    @NonNull
    public NullValue subtractReal(@NonNull RealValue right) {
        return this.toInvalidValue();
    }

    @Override
    @NonNull
    public NullValue symmetricDifference(@NonNull UniqueCollectionValue set) {
        return this.toInvalidValue();
    }

    @NonNull
    protected NullValue toInvalidValue() {
        throw new InvalidValueException(EvaluatorMessages.ConvertibleValueRequired, "Invalid");
    }

    @Override
    @NonNull
    public SequenceValue toSequenceValue() {
        return this;
    }

    @Override
    public void toString(@NonNull StringBuilder s, int sizeLimit) {
        s.append(this.toString());
    }

    @Override
    @NonNull
    public CollectionValue union(@NonNull CollectionValue c) {
        return this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Iterator
    implements java.util.Iterator<Object> {
        private Iterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Object next() {
            return null;
        }

        @Override
        public void remove() {
        }
    }
}

