/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.domain.values.impl;

import java.util.Collection;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.ids.CollectionTypeId;
import org.eclipse.ocl.examples.domain.messages.EvaluatorMessages;
import org.eclipse.ocl.examples.domain.values.OrderedSet;
import org.eclipse.ocl.examples.domain.values.OrderedSetValue;
import org.eclipse.ocl.examples.domain.values.SequenceValue;
import org.eclipse.ocl.examples.domain.values.impl.InvalidValueException;
import org.eclipse.ocl.examples.domain.values.impl.OrderedSetImpl;
import org.eclipse.ocl.examples.domain.values.impl.OrderedSetValueImpl;
import org.eclipse.ocl.examples.domain.values.impl.SparseSequenceValueImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SparseOrderedSetValueImpl
extends OrderedSetValueImpl {
    @NonNull
    public static OrderedSet<Object> createOrderedSetOfEach(@NonNull Object[] boxedValues) {
        OrderedSetImpl<Object> result = new OrderedSetImpl<Object>();
        Object[] objectArray = boxedValues;
        int n = boxedValues.length;
        int n2 = 0;
        while (n2 < n) {
            Object boxedValue = objectArray[n2];
            result.add(boxedValue);
            ++n2;
        }
        return result;
    }

    public SparseOrderedSetValueImpl(@NonNull CollectionTypeId typeId, @NonNull Collection<? extends Object> boxedValues) {
        super(typeId, boxedValues);
    }

    @Override
    @NonNull
    public OrderedSetValue append(@Nullable Object object) {
        if (object instanceof InvalidValueException) {
            throw new InvalidValueException(EvaluatorMessages.InvalidSource, "append");
        }
        OrderedSetImpl<Object> result = new OrderedSetImpl<Object>(this.elements);
        result.remove(object);
        result.add(object);
        return new SparseOrderedSetValueImpl(this.getTypeId(), result);
    }

    @Override
    @Nullable
    public Object first() {
        if (this.elements.size() <= 0) {
            throw new InvalidValueException(EvaluatorMessages.EmptyCollection, "OrderedSet", "first");
        }
        return this.elements.iterator().next();
    }

    @Override
    @NonNull
    public OrderedSetValue flatten() {
        OrderedSetImpl<Object> flattened = new OrderedSetImpl<Object>();
        if (this.flatten(flattened)) {
            return new SparseOrderedSetValueImpl(this.getTypeId(), flattened);
        }
        return this;
    }

    @Override
    @NonNull
    public OrderedSetValue including(@Nullable Object value) {
        if (value instanceof InvalidValueException) {
            throw new InvalidValueException(EvaluatorMessages.InvalidSource, "including");
        }
        OrderedSetImpl<Object> result = new OrderedSetImpl<Object>(this.elements);
        result.add(value);
        return new SparseOrderedSetValueImpl(this.getTypeId(), result);
    }

    @Override
    @Nullable
    public Object last() {
        if (this.elements.size() <= 0) {
            throw new InvalidValueException(EvaluatorMessages.EmptyCollection, "OrderedSet", "last");
        }
        Object result = null;
        for (Object next : this.elements) {
            result = next;
        }
        return result;
    }

    @Override
    @NonNull
    public OrderedSetValue prepend(@Nullable Object object) {
        if (object instanceof InvalidValueException) {
            throw new InvalidValueException(EvaluatorMessages.InvalidSource, "prepend");
        }
        OrderedSetImpl<Object> result = new OrderedSetImpl<Object>();
        result.add(object);
        result.addAll(this.elements);
        return new SparseOrderedSetValueImpl(this.getTypeId(), result);
    }

    @Override
    public SequenceValue toSequenceValue() {
        return new SparseSequenceValueImpl(this.getSequenceTypeId(), SparseSequenceValueImpl.createSequenceOfEach(this.elements));
    }

    @Override
    public void toString(@NonNull StringBuilder s, int lengthLimit) {
        s.append("OrderedSet");
        super.toString(s, lengthLimit);
    }

    public static class Accumulator
    extends SparseOrderedSetValueImpl
    implements OrderedSetValue.Accumulator {
        public Accumulator(@NonNull CollectionTypeId typeId) {
            super(typeId, new OrderedSetImpl());
        }

        public boolean add(@Nullable Object value) {
            return this.elements.add(value);
        }
    }
}

