/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.domain.values.impl;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.elements.DomainStandardLibrary;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.ids.TypeId;
import org.eclipse.ocl.examples.domain.messages.EvaluatorMessages;
import org.eclipse.ocl.examples.domain.types.IdResolver;
import org.eclipse.ocl.examples.domain.values.IntegerValue;
import org.eclipse.ocl.examples.domain.values.RealValue;
import org.eclipse.ocl.examples.domain.values.UnlimitedValue;
import org.eclipse.ocl.examples.domain.values.ValuesPackage;
import org.eclipse.ocl.examples.domain.values.impl.InvalidValueException;
import org.eclipse.ocl.examples.domain.values.impl.NumberValueImpl;
import org.eclipse.ocl.examples.domain.values.util.ValuesUtil;

public class RealValueImpl
extends NumberValueImpl
implements RealValue {
    private static final long serialVersionUID = -6016171050097266652L;
    private static final int MINIMUM_SCALE = 32;
    @NonNull
    private final BigDecimal value;
    private Object integerValue = null;

    protected EClass eStaticClass() {
        return ValuesPackage.Literals.REAL_VALUE;
    }

    @NonNull
    protected static RealValue divideBigDecimal(@NonNull BigDecimal left, @NonNull BigDecimal right) {
        try {
            if (right.signum() == 0) {
                throw new InvalidValueException("divide by zero", new Object[0]);
            }
            int scale = Math.max(left.scale() - right.scale(), 32);
            BigDecimal result = left.divide(right, scale, RoundingMode.HALF_EVEN);
            return ValuesUtil.realValueOf(result);
        }
        catch (ArithmeticException e) {
            throw new InvalidValueException(e, "divideBigDecimal");
        }
    }

    public static void initStatics() {
    }

    public RealValueImpl(double value) {
        this(BigDecimal.valueOf(value));
    }

    public RealValueImpl(@NonNull BigDecimal value) {
        this.value = value;
        assert (value != null);
    }

    @NonNull
    public RealValue abs() {
        BigDecimal result = this.value.abs();
        return ValuesUtil.realValueOf(result);
    }

    @NonNull
    public RealValue addInteger(@NonNull IntegerValue rightValue) {
        try {
            BigDecimal result = this.value.add(rightValue.bigDecimalValue());
            return ValuesUtil.realValueOf(result);
        }
        catch (InvalidValueException e) {
            throw new InvalidValueException(EvaluatorMessages.InvalidReal, e, null, rightValue);
        }
    }

    @NonNull
    public RealValue addReal(@NonNull RealValue rightValue) {
        try {
            BigDecimal result = this.value.add(rightValue.bigDecimalValue());
            return ValuesUtil.realValueOf(result);
        }
        catch (InvalidValueException e) {
            throw new InvalidValueException(EvaluatorMessages.InvalidReal, e, null, rightValue);
        }
    }

    @NonNull
    public Double asDouble() {
        Double result = this.value.doubleValue();
        return result;
    }

    @NonNull
    public Object asEcoreObject(@NonNull IdResolver idResolver) {
        return this.value;
    }

    @NonNull
    public Number asNumber() {
        return this.value;
    }

    @NonNull
    public Object asObject() {
        return this.value;
    }

    @NonNull
    public RealValue asRealValue() {
        return this;
    }

    @NonNull
    public BigDecimal bigDecimalValue() {
        return this.value;
    }

    @NonNull
    public BigInteger bigIntegerValue() {
        Object intValue = this.getIntegerValue();
        if (intValue instanceof Exception) {
            throw new InvalidValueException((Exception)intValue, "bigIntegerValue");
        }
        return ((IntegerValue)intValue).bigIntegerValue();
    }

    @NonNull
    public RealValue commutatedAdd(@NonNull RealValue left) {
        return left.addReal(this);
    }

    @NonNull
    public RealValue commutatedDivide(@NonNull RealValue left) {
        return left.divideReal(this);
    }

    @NonNull
    public RealValue commutatedMultiply(@NonNull RealValue left) {
        return left.multiplyReal(this);
    }

    @NonNull
    public RealValue commutatedSubtract(@NonNull RealValue left) {
        return left.subtractReal(this);
    }

    public int compareTo(RealValue left) {
        return -left.compareToReal(this);
    }

    public int compareToInteger(@NonNull IntegerValue o) {
        return this.value.compareTo(o.bigDecimalValue());
    }

    public int compareToReal(@NonNull RealValue o) {
        return this.value.compareTo(o.bigDecimalValue());
    }

    public int compareToUnlimited(@NonNull UnlimitedValue right) {
        return -1;
    }

    @NonNull
    public RealValue divideInteger(@NonNull IntegerValue right) {
        return RealValueImpl.divideBigDecimal(this.value, right.bigDecimalValue());
    }

    @NonNull
    public RealValue divideReal(@NonNull RealValue right) {
        return RealValueImpl.divideBigDecimal(this.value, right.bigDecimalValue());
    }

    public double doubleValue() {
        return this.value.doubleValue();
    }

    public boolean equals(Object obj) {
        try {
            if (obj instanceof RealValue) {
                BigDecimal bigDecimalValue = ((RealValue)obj).bigDecimalValue();
                return this.value.compareTo(bigDecimalValue) == 0;
            }
            if (obj instanceof IntegerValue) {
                BigDecimal bigDecimalValue = ((IntegerValue)obj).bigDecimalValue();
                return this.value.compareTo(bigDecimalValue) == 0;
            }
        }
        catch (InvalidValueException invalidValueException) {
            // empty catch block
        }
        return this == obj;
    }

    public float floatValue() {
        return this.value.floatValue();
    }

    @NonNull
    public IntegerValue floor() {
        BigInteger result = this.value.setScale(0, RoundingMode.FLOOR).toBigInteger();
        return ValuesUtil.integerValueOf(result);
    }

    protected Object getIntegerValue() {
        if (this.integerValue == null) {
            try {
                BigInteger intValue = this.value.toBigIntegerExact();
                this.integerValue = ValuesUtil.integerValueOf(intValue);
            }
            catch (ArithmeticException e) {
                this.integerValue = e;
            }
        }
        return this.integerValue;
    }

    @NonNull
    public DomainType getType(@NonNull DomainStandardLibrary standardLibrary) {
        return standardLibrary.getRealType();
    }

    @NonNull
    public TypeId getTypeId() {
        return TypeId.REAL;
    }

    public int hashCode() {
        Object intValue = this.getIntegerValue();
        if (intValue instanceof IntegerValue) {
            return intValue.hashCode();
        }
        return this.value.hashCode();
    }

    public int intValue() {
        return this.value.intValue();
    }

    @Nullable
    public IntegerValue isIntegerValue() {
        return null;
    }

    public boolean isUnlimited() {
        return false;
    }

    public long longValue() {
        return this.value.longValue();
    }

    @NonNull
    public RealValue max(@NonNull RealValue rightValue) {
        return rightValue.maxReal(this);
    }

    @NonNull
    public RealValue maxInteger(@NonNull IntegerValue rightValue) {
        try {
            BigDecimal result = this.value.max(rightValue.bigDecimalValue());
            return ValuesUtil.realValueOf(result);
        }
        catch (InvalidValueException e) {
            throw new InvalidValueException(EvaluatorMessages.InvalidReal, e, null, rightValue);
        }
    }

    @NonNull
    public RealValue maxReal(@NonNull RealValue rightValue) {
        try {
            BigDecimal result = this.value.max(rightValue.bigDecimalValue());
            return ValuesUtil.realValueOf(result);
        }
        catch (InvalidValueException e) {
            throw new InvalidValueException(EvaluatorMessages.InvalidReal, e, null, rightValue);
        }
    }

    @NonNull
    public RealValue maxUnlimited(@NonNull UnlimitedValue rightValue) {
        return rightValue;
    }

    @NonNull
    public RealValue min(@NonNull RealValue rightValue) {
        return rightValue.minReal(this);
    }

    @NonNull
    public RealValue minInteger(@NonNull IntegerValue rightValue) {
        try {
            BigDecimal result = this.value.min(rightValue.bigDecimalValue());
            return ValuesUtil.realValueOf(result);
        }
        catch (InvalidValueException e) {
            throw new InvalidValueException(EvaluatorMessages.InvalidReal, e, null, rightValue);
        }
    }

    @NonNull
    public RealValue minReal(@NonNull RealValue rightValue) {
        try {
            BigDecimal result = this.value.min(rightValue.bigDecimalValue());
            return ValuesUtil.realValueOf(result);
        }
        catch (InvalidValueException e) {
            throw new InvalidValueException(EvaluatorMessages.InvalidReal, e, null, rightValue);
        }
    }

    @NonNull
    public RealValue minUnlimited(@NonNull UnlimitedValue rightValue) {
        return this;
    }

    @NonNull
    public RealValue multiplyInteger(@NonNull IntegerValue rightValue) {
        try {
            BigDecimal result = this.value.multiply(rightValue.bigDecimalValue());
            return ValuesUtil.realValueOf(result);
        }
        catch (InvalidValueException e) {
            throw new InvalidValueException(EvaluatorMessages.InvalidReal, e, null, rightValue);
        }
    }

    @NonNull
    public RealValue multiplyReal(@NonNull RealValue rightValue) {
        try {
            BigDecimal result = this.value.multiply(rightValue.bigDecimalValue());
            return ValuesUtil.realValueOf(result);
        }
        catch (InvalidValueException e) {
            throw new InvalidValueException(EvaluatorMessages.InvalidReal, e, null, rightValue);
        }
    }

    @NonNull
    public RealValue negate() {
        BigDecimal result = this.value.negate();
        return ValuesUtil.realValueOf(result);
    }

    @NonNull
    public IntegerValue round() {
        BigDecimal rounded = this.value.signum() >= 0 ? this.value.setScale(0, RoundingMode.HALF_UP) : this.value.negate().setScale(0, RoundingMode.HALF_DOWN).negate();
        BigInteger result = rounded.toBigInteger();
        return ValuesUtil.integerValueOf(result);
    }

    public int signum() {
        return this.value.signum();
    }

    @NonNull
    public RealValue subtractInteger(@NonNull IntegerValue rightValue) {
        try {
            BigDecimal result = this.value.subtract(rightValue.bigDecimalValue());
            return ValuesUtil.realValueOf(result);
        }
        catch (InvalidValueException e) {
            throw new InvalidValueException(EvaluatorMessages.InvalidReal, e, null, rightValue);
        }
    }

    @NonNull
    public RealValue subtractReal(@NonNull RealValue rightValue) {
        try {
            BigDecimal result = this.value.subtract(rightValue.bigDecimalValue());
            return ValuesUtil.realValueOf(result);
        }
        catch (InvalidValueException e) {
            throw new InvalidValueException(EvaluatorMessages.InvalidReal, e, null, rightValue);
        }
    }

    public String toString() {
        return this.value.toString();
    }
}

