/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.domain.values.impl;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.elements.DomainElement;
import org.eclipse.ocl.examples.domain.messages.EvaluatorMessages;
import org.eclipse.ocl.examples.domain.values.BagValue;
import org.eclipse.ocl.examples.domain.values.CollectionValue;
import org.eclipse.ocl.examples.domain.values.IntegerValue;
import org.eclipse.ocl.examples.domain.values.OCLValue;
import org.eclipse.ocl.examples.domain.values.ObjectValue;
import org.eclipse.ocl.examples.domain.values.OrderedCollectionValue;
import org.eclipse.ocl.examples.domain.values.OrderedSetValue;
import org.eclipse.ocl.examples.domain.values.RealValue;
import org.eclipse.ocl.examples.domain.values.SequenceValue;
import org.eclipse.ocl.examples.domain.values.SetValue;
import org.eclipse.ocl.examples.domain.values.TupleValue;
import org.eclipse.ocl.examples.domain.values.UniqueCollectionValue;
import org.eclipse.ocl.examples.domain.values.Value;
import org.eclipse.ocl.examples.domain.values.ValuesPackage;
import org.eclipse.ocl.examples.domain.values.impl.InvalidValueException;

public abstract class NumberValueImpl
extends Number
implements Value {
    private static final long serialVersionUID = 1L;

    protected EClass eStaticClass() {
        return ValuesPackage.Literals.VALUE;
    }

    protected NumberValueImpl() {
    }

    @NonNull
    public BagValue asBagValue() {
        throw new InvalidValueException(EvaluatorMessages.TypedValueRequired, "Bag", this.getTypeName());
    }

    @NonNull
    public CollectionValue asCollectionValue() {
        throw new InvalidValueException(EvaluatorMessages.TypedValueRequired, "Collection", this.getTypeName());
    }

    @NonNull
    public Double asDouble() {
        throw new InvalidValueException(EvaluatorMessages.TypedValueRequired, "Double", this.getTypeName());
    }

    @Deprecated
    @Nullable
    public Object asEcoreObject() {
        return this.asObject();
    }

    public DomainElement asElement() {
        return null;
    }

    @NonNull
    public Integer asInteger() {
        throw new InvalidValueException(EvaluatorMessages.TypedValueRequired, "Integer", this.getTypeName());
    }

    @NonNull
    public IntegerValue asIntegerValue() {
        throw new InvalidValueException(EvaluatorMessages.TypedValueRequired, "Integer", this.getTypeName());
    }

    @NonNull
    public EObject asNavigableObject() {
        Object object = this.asObject();
        if (object instanceof EObject) {
            return (EObject)object;
        }
        throw new InvalidValueException(EvaluatorMessages.TypedValueRequired, "Object", this.getTypeName());
    }

    @NonNull
    public ObjectValue asObjectValue() {
        throw new InvalidValueException(EvaluatorMessages.TypedValueRequired, "Object", this.getTypeName());
    }

    @NonNull
    public OrderedCollectionValue asOrderedCollectionValue() {
        throw new InvalidValueException(EvaluatorMessages.TypedValueRequired, "OrderedCollection", this.getTypeName());
    }

    @NonNull
    public OrderedSetValue asOrderedSetValue() {
        throw new InvalidValueException(EvaluatorMessages.TypedValueRequired, "OrderedSet", this.getTypeName());
    }

    @NonNull
    public RealValue asRealValue() {
        throw new InvalidValueException(EvaluatorMessages.TypedValueRequired, "Real", this.getTypeName());
    }

    @NonNull
    public SequenceValue asSequenceValue() {
        throw new InvalidValueException(EvaluatorMessages.TypedValueRequired, "Sequence", this.getTypeName());
    }

    @NonNull
    public SetValue asSetValue() {
        throw new InvalidValueException(EvaluatorMessages.TypedValueRequired, "Set", this.getTypeName());
    }

    @NonNull
    public TupleValue asTupleValue() {
        throw new InvalidValueException(EvaluatorMessages.TypedValueRequired, "Tuple", this.getTypeName());
    }

    @NonNull
    public UniqueCollectionValue asUniqueCollectionValue() {
        throw new InvalidValueException(EvaluatorMessages.TypedValueRequired, "Unique Collection", this.getTypeName());
    }

    @NonNull
    public Value asUnlimitedNaturalValue() {
        throw new InvalidValueException(EvaluatorMessages.TypedValueRequired, "UnlimitedNatural", this.getTypeName());
    }

    @NonNull
    public String getTypeName() {
        return this.getTypeId().getDisplayName();
    }

    public boolean isInvalid() {
        return false;
    }

    public boolean isUndefined() {
        return false;
    }

    public boolean oclEquals(@NonNull OCLValue thatValue) {
        return this.equals(thatValue);
    }

    public int oclHashCode() {
        return this.hashCode();
    }

    public void toString(@NonNull StringBuilder s, int sizeLimit) {
        s.append(this.toString());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class EmptyIterator
    implements Iterator<Value> {
        EmptyIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Value next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new IllegalStateException();
        }
    }
}

