/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.domain.values.impl;

import java.math.BigDecimal;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.elements.DomainStandardLibrary;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.ids.TypeId;
import org.eclipse.ocl.examples.domain.messages.EvaluatorMessages;
import org.eclipse.ocl.examples.domain.values.IntegerValue;
import org.eclipse.ocl.examples.domain.values.RealValue;
import org.eclipse.ocl.examples.domain.values.UnlimitedValue;
import org.eclipse.ocl.examples.domain.values.Value;
import org.eclipse.ocl.examples.domain.values.ValuesPackage;
import org.eclipse.ocl.examples.domain.values.impl.InvalidValueException;
import org.eclipse.ocl.examples.domain.values.impl.NumberValueImpl;
import org.eclipse.ocl.examples.domain.values.impl.RealValueImpl;
import org.eclipse.ocl.examples.domain.values.util.ValuesUtil;

public abstract class IntegerValueImpl
extends NumberValueImpl
implements IntegerValue {
    private static final long serialVersionUID = 1L;

    protected EClass eStaticClass() {
        return ValuesPackage.Literals.INTEGER_VALUE;
    }

    @NonNull
    public RealValue addReal(@NonNull RealValue rightValue) {
        try {
            BigDecimal result = this.bigDecimalValue().add(rightValue.bigDecimalValue());
            return ValuesUtil.realValueOf(result);
        }
        catch (InvalidValueException e) {
            throw new InvalidValueException(EvaluatorMessages.InvalidReal, e, null, rightValue);
        }
    }

    @NonNull
    public IntegerValue asIntegerValue() {
        return this;
    }

    @NonNull
    public RealValue asRealValue() {
        return this;
    }

    @NonNull
    public Value asUnlimitedNaturalValue() {
        if (this.isUnlimitedNatural()) {
            return this;
        }
        return super.asUnlimitedNaturalValue();
    }

    @NonNull
    public RealValue commutatedAdd(@NonNull RealValue left) {
        return left.addInteger(this);
    }

    @NonNull
    public IntegerValue commutatedDiv(@NonNull IntegerValue left) {
        return left.divInteger(this);
    }

    @NonNull
    public RealValue commutatedDivide(@NonNull RealValue left) {
        return left.divideInteger(this);
    }

    @NonNull
    public IntegerValue commutatedMod(@NonNull IntegerValue left) {
        return left.modInteger(this);
    }

    @NonNull
    public RealValue commutatedMultiply(@NonNull RealValue left) {
        return left.multiplyInteger(this);
    }

    @NonNull
    public RealValue commutatedSubtract(@NonNull RealValue left) {
        return left.subtractInteger(this);
    }

    public int compareTo(RealValue left) {
        return -left.compareToInteger(this);
    }

    public int compareToReal(@NonNull RealValue o) {
        return this.bigDecimalValue().compareTo(o.bigDecimalValue());
    }

    public int compareToUnlimited(@NonNull UnlimitedValue right) {
        return -1;
    }

    @NonNull
    public IntegerValue divUnlimited(@NonNull UnlimitedValue right) {
        throw new InvalidValueException(EvaluatorMessages.InvalidOperation, "div", "UnlimitedValue");
    }

    @NonNull
    public RealValue divideReal(@NonNull RealValue right) {
        return RealValueImpl.divideBigDecimal(this.bigDecimalValue(), right.bigDecimalValue());
    }

    @NonNull
    public IntegerValue floor() {
        return this;
    }

    @NonNull
    public DomainType getType(@NonNull DomainStandardLibrary standardLibrary) {
        return this.isUnlimitedNatural() ? standardLibrary.getUnlimitedNaturalType() : standardLibrary.getIntegerType();
    }

    @NonNull
    public TypeId getTypeId() {
        return this.isUnlimitedNatural() ? TypeId.UNLIMITED_NATURAL : TypeId.INTEGER;
    }

    @Nullable
    public IntegerValue isIntegerValue() {
        return this;
    }

    public boolean isUnlimited() {
        return false;
    }

    public boolean isUnlimitedNatural() {
        return false;
    }

    @NonNull
    public RealValue max(@NonNull RealValue rightValue) {
        return rightValue.maxInteger(this);
    }

    @NonNull
    public RealValue maxReal(@NonNull RealValue right) {
        BigDecimal bigDecimalValue = this.bigDecimalValue();
        return bigDecimalValue.compareTo(right.bigDecimalValue()) > 0 ? ValuesUtil.realValueOf(bigDecimalValue) : right;
    }

    @NonNull
    public RealValue maxUnlimited(@NonNull UnlimitedValue rightValue) {
        return rightValue;
    }

    @NonNull
    public RealValue min(@NonNull RealValue rightValue) {
        return rightValue.minInteger(this);
    }

    @NonNull
    public RealValue minReal(@NonNull RealValue right) {
        BigDecimal bigDecimalValue = this.bigDecimalValue();
        return bigDecimalValue.compareTo(right.bigDecimalValue()) < 0 ? ValuesUtil.realValueOf(bigDecimalValue) : right;
    }

    @NonNull
    public RealValue minUnlimited(@NonNull UnlimitedValue rightValue) {
        return this;
    }

    @NonNull
    public IntegerValue modUnlimited(@NonNull UnlimitedValue right) {
        throw new InvalidValueException(EvaluatorMessages.InvalidOperation, "mod", "UnlimitedValue");
    }

    @NonNull
    public RealValue multiplyReal(@NonNull RealValue rightValue) {
        try {
            BigDecimal result = this.bigDecimalValue().multiply(rightValue.bigDecimalValue());
            return ValuesUtil.realValueOf(result);
        }
        catch (InvalidValueException e) {
            throw new InvalidValueException(EvaluatorMessages.InvalidReal, e, null, rightValue);
        }
    }

    @NonNull
    public IntegerValue round() {
        return this;
    }

    @NonNull
    public RealValue subtractReal(@NonNull RealValue rightValue) {
        try {
            BigDecimal result = this.bigDecimalValue().subtract(rightValue.bigDecimalValue());
            return ValuesUtil.realValueOf(result);
        }
        catch (InvalidValueException e) {
            throw new InvalidValueException(EvaluatorMessages.InvalidReal, e, null, rightValue);
        }
    }
}

