/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.domain.types;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.elements.DomainCallExp;
import org.eclipse.ocl.examples.domain.elements.DomainConstraint;
import org.eclipse.ocl.examples.domain.elements.DomainFragment;
import org.eclipse.ocl.examples.domain.elements.DomainInheritance;
import org.eclipse.ocl.examples.domain.elements.DomainOperation;
import org.eclipse.ocl.examples.domain.elements.DomainPackage;
import org.eclipse.ocl.examples.domain.elements.DomainProperty;
import org.eclipse.ocl.examples.domain.elements.DomainStandardLibrary;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.ids.OperationId;
import org.eclipse.ocl.examples.domain.ids.ParametersId;
import org.eclipse.ocl.examples.domain.ids.TypeId;
import org.eclipse.ocl.examples.domain.library.LibraryFeature;
import org.eclipse.ocl.examples.domain.library.UnsupportedOperation;
import org.eclipse.ocl.examples.domain.types.IdResolver;
import org.eclipse.ocl.examples.domain.utilities.DomainUtil;
import org.eclipse.ocl.examples.domain.utilities.IndexableIterable;
import org.eclipse.ocl.examples.domain.values.OCLValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractInheritance
implements DomainInheritance {
    public static final int ORDERED = 1;
    public static final int UNIQUE = 2;
    @NonNull
    protected final String name;
    @NonNull
    protected final DomainPackage evaluationPackage;
    protected final int flags;
    protected Map<String, DomainOperation> operationMap = null;
    protected Map<String, DomainProperty> propertyMap = null;

    public static void initStatics() {
    }

    public AbstractInheritance(@NonNull String name, @NonNull DomainPackage evaluationPackage, int flags) {
        this.name = name;
        this.evaluationPackage = evaluationPackage;
        this.flags = flags;
    }

    @Override
    public boolean conformsTo(@NonNull DomainStandardLibrary standardLibrary, @NonNull DomainType type) {
        DomainInheritance thatInheritance = type.getInheritance(standardLibrary);
        if (this == thatInheritance) {
            return true;
        }
        return thatInheritance.isSuperInheritanceOf(standardLibrary, this);
    }

    @Override
    @NonNull
    public DomainInheritance getCommonInheritance(@NonNull DomainInheritance thatInheritance) {
        if (this == thatInheritance) {
            return this;
        }
        int thatDepth = thatInheritance.getDepth();
        if (thatDepth == 1 && thatInheritance.isUndefined()) {
            return this;
        }
        int thisDepth = this.getDepth();
        int staticDepth = Math.min(thisDepth, thatDepth);
        while (staticDepth > 0) {
            int iMax = this.getIndex(staticDepth + 1);
            int jMax = thatInheritance.getIndex(staticDepth + 1);
            DomainInheritance commonInheritance = null;
            int commonInheritances = 0;
            int i = this.getIndex(staticDepth);
            while (i < iMax) {
                DomainInheritance thisBaseInheritance = this.getFragment(i).getBaseInheritance();
                int j = thatInheritance.getIndex(staticDepth);
                while (j < jMax) {
                    DomainInheritance thatBaseInheritance = thatInheritance.getFragment(j).getBaseInheritance();
                    if (thisBaseInheritance == thatBaseInheritance) {
                        ++commonInheritances;
                        commonInheritance = thisBaseInheritance;
                        break;
                    }
                    ++j;
                }
                if (commonInheritances > 1) break;
                ++i;
            }
            if (commonInheritances == 1) {
                assert (commonInheritance != null);
                return commonInheritance;
            }
            --staticDepth;
        }
        return this.getFragment(0).getBaseInheritance();
    }

    @Override
    @NonNull
    public DomainType getCommonType(@NonNull IdResolver idResolver, @NonNull DomainType type) {
        if (this == type) {
            return this;
        }
        AbstractInheritance firstInheritance = this;
        DomainInheritance secondInheritance = type.getInheritance(idResolver.getStandardLibrary());
        DomainInheritance commonInheritance = firstInheritance.getCommonInheritance(secondInheritance);
        return commonInheritance;
    }

    @Override
    @Nullable
    public DomainFragment getFragment(@NonNull DomainInheritance thatInheritance) {
        int staticDepth = thatInheritance.getDepth();
        if (staticDepth <= this.getDepth()) {
            int iMax = this.getIndex(staticDepth + 1);
            int i = this.getIndex(staticDepth);
            while (i < iMax) {
                DomainFragment fragment = this.getFragment(i);
                if (fragment.getBaseInheritance() == thatInheritance) {
                    return fragment;
                }
                ++i;
            }
        }
        return null;
    }

    @Override
    @NonNull
    public DomainInheritance getInheritance(@NonNull DomainStandardLibrary standardLibrary) {
        return this;
    }

    @Override
    @Nullable
    public DomainOperation getMemberOperation(@NonNull OperationId operationId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    @NonNull
    public DomainType getNormalizedType(@NonNull DomainStandardLibrary standardLibrary) {
        return this;
    }

    @NonNull
    protected DomainInheritance getOclAnyInheritance() {
        DomainStandardLibrary standardLibrary = this.getStandardLibrary();
        DomainType oclAnyType = standardLibrary.getOclAnyType();
        return oclAnyType.getInheritance(standardLibrary);
    }

    @Override
    @NonNull
    public List<? extends DomainConstraint> getOwnedInvariant() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NonNull
    public List<? extends DomainConstraint> getOwnedRule() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NonNull
    public final DomainPackage getPackage() {
        return this.evaluationPackage;
    }

    @Override
    public boolean isEqualTo(@NonNull DomainStandardLibrary standardLibrary, @NonNull DomainType type) {
        return this == type;
    }

    @Override
    public boolean isEqualToUnspecializedType(@NonNull DomainStandardLibrary standardLibrary, @NonNull DomainType type) {
        return this == type;
    }

    @Override
    public boolean isInvalid() {
        return false;
    }

    @Override
    public boolean isOrdered() {
        return (this.flags & 1) != 0;
    }

    @Override
    public boolean isSubInheritanceOf(@NonNull DomainInheritance thatInheritance) {
        return this.getFragment(thatInheritance) != null;
    }

    @Override
    public boolean isSuperInheritanceOf(@NonNull DomainStandardLibrary standardLibrary, @NonNull DomainInheritance thatInheritance) {
        return thatInheritance.getFragment(this) != null;
    }

    @Override
    public boolean isUndefined() {
        return false;
    }

    @Override
    public boolean isUnique() {
        return (this.flags & 2) != 0;
    }

    @Override
    @NonNull
    public LibraryFeature lookupImplementation(@NonNull DomainStandardLibrary standardLibrary, @NonNull DomainOperation staticOperation) {
        LibraryFeature implementation;
        this.getDepth();
        DomainInheritance staticInheritance = staticOperation.getInheritance(standardLibrary);
        int staticDepth = DomainUtil.nonNullModel(staticInheritance).getDepth();
        if (staticDepth + 1 < this.getIndexes()) {
            int iMax = this.getIndex(staticDepth + 1);
            int i = this.getIndex(staticDepth);
            while (i < iMax) {
                DomainFragment fragment = this.getFragment(i);
                if (fragment.getBaseInheritance() == staticInheritance) {
                    return fragment.getImplementation(staticOperation);
                }
                ++i;
            }
        }
        if ((implementation = staticOperation.getImplementation()) == null) {
            implementation = UnsupportedOperation.INSTANCE;
        }
        return implementation;
    }

    @Override
    @Nullable
    public DomainOperation lookupLocalOperation(@NonNull DomainStandardLibrary standardLibrary, @NonNull String operationName, DomainInheritance ... argumentTypes) {
        for (DomainOperation domainOperation : this.getLocalOperations()) {
            ParametersId firstParametersId;
            int iMax;
            if (!domainOperation.getName().equals(operationName) || (iMax = (firstParametersId = domainOperation.getParametersId()).size()) != argumentTypes.length) continue;
            int i = 0;
            while (i < iMax) {
                TypeId firstParameterId = (TypeId)firstParametersId.get(i);
                DomainInheritance secondParameterType = argumentTypes[i];
                if (secondParameterType == null || firstParameterId != secondParameterType.getTypeId()) break;
                ++i;
            }
            if (i < iMax) continue;
            return domainOperation;
        }
        return null;
    }

    @Override
    public boolean oclEquals(@NonNull OCLValue thatValue) {
        if (!(thatValue instanceof DomainType)) {
            return false;
        }
        TypeId thisTypeId = this.getTypeId();
        TypeId thatTypeId = ((DomainType)thatValue).getTypeId();
        return thisTypeId.equals(thatTypeId);
    }

    @Override
    public int oclHashCode() {
        return this.getTypeId().hashCode();
    }

    @Override
    public DomainType specializeIn(@NonNull DomainCallExp expr, DomainType selfType) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return String.valueOf(String.valueOf(this.evaluationPackage)) + "::" + String.valueOf(this.name);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FragmentIterable
    implements IndexableIterable<DomainFragment> {
        private final DomainFragment[] array;
        private final int firstIndex;
        private final int lastIndex;

        public FragmentIterable(@NonNull DomainFragment[] array) {
            this.array = array;
            this.firstIndex = 0;
            this.lastIndex = array.length;
        }

        public FragmentIterable(@NonNull DomainFragment[] array, int firstIndex, int lastIndex) {
            this.array = array;
            this.firstIndex = firstIndex;
            this.lastIndex = lastIndex;
        }

        @Override
        @NonNull
        public DomainFragment get(int index) {
            return DomainUtil.nonNullState(this.array[this.firstIndex + index]);
        }

        @Override
        @NonNull
        public java.util.Iterator<DomainFragment> iterator() {
            return new Iterator();
        }

        @Override
        public int size() {
            return this.lastIndex - this.firstIndex;
        }

        public String toString() {
            StringBuilder s = null;
            int i = this.firstIndex;
            while (i < this.lastIndex) {
                if (s == null) {
                    s = new StringBuilder();
                    s.append("[");
                } else {
                    s.append(", ");
                }
                s.append(this.array[i]);
                ++i;
            }
            if (s == null) {
                return "";
            }
            s.append("]");
            return s.toString();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        protected class Iterator
        implements java.util.Iterator<DomainFragment> {
            private int index;

            protected Iterator() {
                this.index = FragmentIterable.this.firstIndex;
            }

            @Override
            public boolean hasNext() {
                return this.index < FragmentIterable.this.lastIndex;
            }

            @Override
            public DomainFragment next() {
                return FragmentIterable.this.array[this.index++];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }
}

