/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.domain.library;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.elements.DomainExpression;
import org.eclipse.ocl.examples.domain.elements.DomainTypedElement;
import org.eclipse.ocl.examples.domain.evaluation.DomainEvaluator;
import org.eclipse.ocl.examples.domain.library.EvaluatorIterationManager;
import org.eclipse.ocl.examples.domain.values.CollectionValue;

public class EvaluatorMultipleIterationManager
extends EvaluatorIterationManager {
    protected final EvaluatorIterationManager.ValueIterator[] iterators;
    protected boolean hasCurrent;

    public EvaluatorMultipleIterationManager(@NonNull DomainEvaluator invokingEvaluator, @NonNull DomainExpression body, @NonNull CollectionValue collectionValue, @Nullable DomainTypedElement accumulator, @Nullable Object accumulatorValue, DomainTypedElement ... referredIterators) {
        super(invokingEvaluator.createNestedEvaluator(), body, collectionValue, accumulator, accumulatorValue);
        int iMax = referredIterators.length;
        EvaluatorIterationManager.ValueIterator[] iterators = new EvaluatorIterationManager.ValueIterator[iMax];
        int i = 0;
        while (i < iMax) {
            DomainTypedElement referredIterator = referredIterators[i];
            if (referredIterator != null) {
                EvaluatorIterationManager.ValueIterator valueIterator = new EvaluatorIterationManager.ValueIterator(this.evaluator, collectionValue, referredIterator);
                if (!valueIterator.hasCurrent()) {
                    this.iterators = null;
                    this.hasCurrent = false;
                    return;
                }
                iterators[i] = valueIterator;
            }
            ++i;
        }
        this.iterators = iterators;
        this.hasCurrent = true;
    }

    public boolean advanceIterators() {
        if (this.hasCurrent) {
            EvaluatorIterationManager.ValueIterator[] valueIteratorArray = this.iterators;
            int n = this.iterators.length;
            int n2 = 0;
            while (n2 < n) {
                EvaluatorIterationManager.ValueIterator advancingIterator = valueIteratorArray[n2];
                advancingIterator.next();
                if (advancingIterator.hasCurrent()) {
                    EvaluatorIterationManager.ValueIterator[] valueIteratorArray2 = this.iterators;
                    int n3 = this.iterators.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        EvaluatorIterationManager.ValueIterator previousIterator = valueIteratorArray2[n4];
                        if (previousIterator == advancingIterator) {
                            return true;
                        }
                        previousIterator.reset();
                        ++n4;
                    }
                }
                ++n2;
            }
            this.hasCurrent = false;
        }
        return false;
    }

    @NonNull
    public Object get(int i) {
        Object currentValue = this.iterators[i].get();
        if (currentValue == null) {
            throw new IllegalStateException("cannot get() after iteration complete");
        }
        return currentValue;
    }

    public boolean hasCurrent() {
        return this.hasCurrent;
    }
}

