/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.domain.ids.impl;

import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.domain.ids.ElementId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WeakHashMapOfWeakReference<K, V extends ElementId>
extends WeakHashMap<K, WeakReference<V>> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public V getId(@NonNull K key) {
        ElementId oldId;
        WeakReference ref = (WeakReference)this.get(key);
        if (ref != null && (oldId = (ElementId)ref.get()) != null) {
            return (V)oldId;
        }
        WeakHashMapOfWeakReference weakHashMapOfWeakReference = this;
        synchronized (weakHashMapOfWeakReference) {
            ElementId oldId2;
            ref = (WeakReference)this.get(key);
            if (ref != null && (oldId2 = (ElementId)ref.get()) != null) {
                return (V)oldId2;
            }
            V newId = this.newId(key);
            this.put(key, new WeakReference<V>(newId));
            return newId;
        }
    }

    @NonNull
    protected abstract V newId(@NonNull K var1);

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("{");
        Iterator i = this.entrySet().iterator();
        boolean hasNext = i.hasNext();
        while (hasNext) {
            ElementId value;
            Map.Entry e = i.next();
            WeakReference ref = (WeakReference)e.getValue();
            if (ref == null || (value = (ElementId)ref.get()) == null) continue;
            Object key = e.getKey();
            if (key == this) {
                buf.append("(this Map)");
            } else {
                buf.append(key);
            }
            buf.append("=");
            if (value == this) {
                buf.append("(this Map)");
            } else {
                buf.append(value);
            }
            hasNext = i.hasNext();
            if (!hasNext) continue;
            buf.append(", ");
        }
        buf.append("}");
        return buf.toString();
    }
}

