/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.tools.extendedtypes.settypeactionconfiguration;

import java.util.Arrays;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.papyrus.infra.extendedtypes.IActionEditHelperAdvice;
import org.eclipse.papyrus.infra.extendedtypes.emf.Activator;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.infra.widgets.creation.ReferenceValueFactory;
import org.eclipse.papyrus.uml.properties.modelelement.UMLModelElement;
import org.eclipse.papyrus.uml.tools.extendedtypes.settypeactionconfiguration.SetTypeActionConfiguration;
import org.eclipse.swt.widgets.Display;
import org.eclipse.uml2.uml.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetTypeActionEditHelperAdvice
extends AbstractEditHelperAdvice
implements IActionEditHelperAdvice<SetTypeActionConfiguration> {
    protected SetTypeActionConfiguration configuration;

    public void init(SetTypeActionConfiguration configuration) {
        this.configuration = configuration;
    }

    public boolean approveRequest(IEditCommandRequest request) {
        return super.approveRequest(request);
    }

    protected ICommand getBeforeConfigureCommand(ConfigureRequest request) {
        return super.getBeforeConfigureCommand(request);
    }

    protected ICommand getAfterConfigureCommand(ConfigureRequest request) {
        if (this.configuration == null) {
            return null;
        }
        AbstractTransactionalCommand resultCommand = null;
        final EObject elementToConfigure = request.getElementToConfigure();
        if (!(elementToConfigure instanceof Element)) {
            return null;
        }
        final TransactionalEditingDomain editingDomain = request.getEditingDomain();
        if (editingDomain == null) {
            return null;
        }
        IElementEditService service = ElementEditServiceUtils.getCommandProvider((Object)elementToConfigure);
        if (service == null) {
            Activator.log.error("Impossible to get edit service from element: " + elementToConfigure, null);
            return null;
        }
        resultCommand = new AbstractTransactionalCommand(editingDomain, "Editing type", Arrays.asList(WorkspaceSynchronizer.getFile((Resource)elementToConfigure.eResource()))){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                UMLModelElement umlModelElement = new UMLModelElement(elementToConfigure, (EditingDomain)editingDomain);
                ReferenceValueFactory factory = umlModelElement.getValueFactory("type");
                Object elemObject = factory.edit(Display.getDefault().getFocusControl(), (Object)elementToConfigure);
                return CommandResult.newOKCommandResult((Object)elemObject);
            }
        };
        return resultCommand;
    }

    protected EObject getDefaultTypeContainer(ConfigureRequest request) {
        if (request.getElementToConfigure() instanceof Element) {
            return ((Element)request.getElementToConfigure()).getNearestPackage();
        }
        return request.getElementToConfigure().eContainer();
    }
}

