/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.tools.extendedtypes.applystereotypeactionconfiguration;

import java.util.Collection;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.papyrus.infra.extendedtypes.IActionEditHelperAdvice;
import org.eclipse.papyrus.infra.extendedtypes.emf.Activator;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.uml.tools.extendedtypes.applystereotypeactionconfiguration.ApplyStereotypeActionConfiguration;
import org.eclipse.papyrus.uml.tools.extendedtypes.applystereotypeactionconfiguration.FeatureToSet;
import org.eclipse.papyrus.uml.tools.extendedtypes.applystereotypeactionconfiguration.FeatureValue;
import org.eclipse.papyrus.uml.tools.extendedtypes.applystereotypeactionconfiguration.StereotypeFeatureValueUtils;
import org.eclipse.papyrus.uml.tools.extendedtypes.applystereotypeactionconfiguration.StereotypeToApply;
import org.eclipse.papyrus.uml.tools.utils.NamedElementUtil;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.TypedElement;
import org.eclipse.uml2.uml.UMLPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplyStereotypeActionEditHelperAdvice
extends AbstractEditHelperAdvice
implements IActionEditHelperAdvice<ApplyStereotypeActionConfiguration> {
    protected ApplyStereotypeActionConfiguration configuration;

    public void init(ApplyStereotypeActionConfiguration configuration) {
        this.configuration = configuration;
    }

    public boolean approveRequest(IEditCommandRequest request) {
        return super.approveRequest(request);
    }

    protected ICommand getBeforeConfigureCommand(ConfigureRequest request) {
        return super.getBeforeConfigureCommand(request);
    }

    protected ICommand getAfterConfigureCommand(ConfigureRequest request) {
        if (this.configuration == null) {
            return null;
        }
        ApplyStereotypeCommand resultCommand = null;
        EObject elementToConfigure = request.getElementToConfigure();
        if (!(elementToConfigure instanceof Element)) {
            return null;
        }
        TransactionalEditingDomain editingDomain = request.getEditingDomain();
        if (editingDomain == null) {
            return null;
        }
        IElementEditService service = ElementEditServiceUtils.getCommandProvider((Object)elementToConfigure);
        if (service == null) {
            Activator.log.error("Impossible to get edit service from element: " + elementToConfigure, null);
            return null;
        }
        for (StereotypeToApply stereotypeToApply : this.configuration.getStereotypesToApply()) {
            Stereotype stereotype = ((Element)elementToConfigure).getApplicableStereotype(stereotypeToApply.getStereotypeQualifiedName());
            if (stereotype == null) continue;
            ApplyStereotypeCommand applyStereotypeCommand = new ApplyStereotypeCommand(editingDomain, (Element)elementToConfigure, stereotype, stereotypeToApply.isUpdateName());
            resultCommand = resultCommand == null ? applyStereotypeCommand : resultCommand.compose((IUndoableOperation)applyStereotypeCommand);
            for (FeatureToSet featureToSet : stereotypeToApply.getFeaturesToSet()) {
                ICommand command = this.getSetStereotypeFeatureValueCommand((Element)elementToConfigure, stereotype, featureToSet.getFeatureName(), featureToSet.getValue(), service, request);
                if (command == null) continue;
                resultCommand = resultCommand == null ? command : resultCommand.compose((IUndoableOperation)command);
            }
        }
        if (resultCommand != null) {
            return resultCommand.reduce();
        }
        return super.getAfterConfigureCommand(request);
    }

    protected ICommand getSetStereotypeFeatureValueCommand(Element elementToConfigure, Stereotype stereotype, String name, FeatureValue featureValue, IElementEditService service, ConfigureRequest configureRequest) {
        if (name == null) {
            Activator.log.debug("No feature name has been set.");
            return null;
        }
        if (elementToConfigure.eClass() == null) {
            Activator.log.error("Impossible to find EClass from EObject: " + elementToConfigure, null);
            return null;
        }
        if (configureRequest.getEditingDomain() == null) {
            return null;
        }
        TypedElement typedElement = (TypedElement)stereotype.getMember(name, true, UMLPackage.eINSTANCE.getTypedElement());
        if (typedElement == null) {
            Activator.log.error("Impossible to find feature " + name + " for eobject " + elementToConfigure, null);
            return null;
        }
        Object value = this.getStereotypeValue(elementToConfigure, stereotype, typedElement.getType(), featureValue);
        return new SetStereotypeValueCommand(configureRequest.getEditingDomain(), elementToConfigure, stereotype, name, value);
    }

    protected Object getStereotypeValue(Element elementToConfigure, Stereotype stereotype, Type type, FeatureValue featureValue) {
        return StereotypeFeatureValueUtils.getValue((EObject)elementToConfigure, stereotype, type, featureValue);
    }

    public static class ApplyStereotypeCommand
    extends AbstractTransactionalCommand {
        private Stereotype stereotype;
        private Element element;
        private boolean rename;

        public ApplyStereotypeCommand(TransactionalEditingDomain domain, Element element, Stereotype stereotype, boolean rename) {
            super(domain, "Apply Stereotype " + stereotype.getLabel(), ApplyStereotypeCommand.getWorkspaceFiles((EObject)element));
            this.element = element;
            this.stereotype = stereotype;
            this.rename = rename;
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            try {
                EObject stereotypeApplication = this.element.applyStereotype(this.stereotype);
                if (this.rename && this.element instanceof NamedElement && ((NamedElement)this.element).getNamespace() != null) {
                    String newName = NamedElementUtil.getDefaultNameWithIncrementFromBase((String)this.stereotype.getName(), (Collection)((NamedElement)this.element).getNamespace().getMembers());
                    ((NamedElement)this.element).setName(newName);
                }
                return CommandResult.newOKCommandResult((Object)stereotypeApplication);
            }
            catch (Throwable t) {
                Activator.log.error(t);
                return CommandResult.newErrorCommandResult((String)t.getMessage());
            }
        }
    }

    public static class SetStereotypeValueCommand
    extends AbstractTransactionalCommand {
        private Element element;
        private Stereotype stereotype;
        private String featureName;
        private Object featureValue;

        public SetStereotypeValueCommand(TransactionalEditingDomain domain, Element element, Stereotype stereotype, String featureName, Object featureValue) {
            super(domain, "Set stereotype  value " + featureName, SetStereotypeValueCommand.getWorkspaceFiles((EObject)element.getStereotypeApplication(stereotype)));
            this.element = element;
            this.stereotype = stereotype;
            this.featureName = featureName;
            this.featureValue = featureValue;
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            try {
                this.element.setValue(this.stereotype, this.featureName, this.featureValue);
            }
            catch (Throwable t) {
                Activator.log.error(t);
                return CommandResult.newErrorCommandResult((String)t.getMessage());
            }
            return CommandResult.newOKCommandResult((Object)this.element.getValue(this.stereotype, this.featureName));
        }
    }
}

