/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.workspace.internal.efs;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.cdo.workspace.internal.efs.AbstractFileStore;
import org.eclipse.emf.cdo.workspace.internal.efs.CDOWorkspaceFileSystem;
import org.eclipse.emf.cdo.workspace.internal.efs.CDOWorkspaceStore;

public final class CDOProjectDescriptionStore
extends AbstractFileStore {
    public static final String DESCRIPTION_FILE_NAME = ".project";
    private CDOWorkspaceStore workspaceStore;

    public CDOProjectDescriptionStore(CDOWorkspaceStore workspaceStore) {
        this.workspaceStore = workspaceStore;
    }

    public CDOWorkspaceStore getWorkspaceStore() {
        return this.workspaceStore;
    }

    public IFileStore getParent() {
        return this.workspaceStore;
    }

    public String getName() {
        return DESCRIPTION_FILE_NAME;
    }

    public String[] childNames(int options, IProgressMonitor monitor) throws CoreException {
        return CDOWorkspaceFileSystem.NO_CHILD_NAMES;
    }

    public IFileStore getChild(String name) {
        return new AbstractFileStore.Invalid((IFileStore)this, name);
    }

    public void copy(IFileStore destination, int options, IProgressMonitor monitor) throws CoreException {
        this.getLocalFile().copy(destination, options, monitor);
    }

    public void delete(int options, IProgressMonitor monitor) throws CoreException {
        this.getLocalFile().delete(options, monitor);
    }

    public IFileInfo fetchInfo() {
        return this.getLocalFile().fetchInfo();
    }

    public IFileInfo fetchInfo(int options, IProgressMonitor monitor) throws CoreException {
        return this.getLocalFile().fetchInfo(options, monitor);
    }

    public IFileStore getFileStore(IPath path) {
        return this.getLocalFile().getFileStore(path);
    }

    public boolean isParentOf(IFileStore other) {
        return this.getLocalFile().isParentOf(other);
    }

    public IFileStore mkdir(int options, IProgressMonitor monitor) throws CoreException {
        return this.getLocalFile().mkdir(options, monitor);
    }

    public void move(IFileStore destination, int options, IProgressMonitor monitor) throws CoreException {
        this.getLocalFile().move(destination, options, monitor);
    }

    public InputStream openInputStream(int options, IProgressMonitor monitor) throws CoreException {
        return this.getLocalFile().openInputStream(options, monitor);
    }

    public OutputStream openOutputStream(int options, IProgressMonitor monitor) throws CoreException {
        return this.getLocalFile().openOutputStream(options, monitor);
    }

    public void putInfo(IFileInfo info, int options, IProgressMonitor monitor) throws CoreException {
        this.getLocalFile().putInfo(info, options, monitor);
    }

    public File toLocalFile(int options, IProgressMonitor monitor) throws CoreException {
        return this.getLocalFile().toLocalFile(options, monitor);
    }

    private IFileStore getLocalFile() {
        File file = new File(this.workspaceStore.getLocation(), DESCRIPTION_FILE_NAME);
        return EFS.getLocalFileSystem().fromLocalFile(file);
    }
}

