/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.workspace.internal.efs;

import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.provider.FileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.cdo.workspace.internal.efs.CDOWorkspaceFileSystem;
import org.eclipse.net4j.util.WrappedException;

public abstract class AbstractFileStore
extends FileStore {
    public CDOWorkspaceFileSystem getFileSystem() {
        return CDOWorkspaceFileSystem.getInstance();
    }

    public URI toURI() {
        try {
            return new URI(String.valueOf(this.getParent().toURI().toString()) + "/" + this.getName());
        }
        catch (URISyntaxException ex) {
            throw WrappedException.wrap((Exception)ex);
        }
    }

    public static final class Invalid
    extends AbstractFileStore {
        private IFileStore parent;
        private String name;

        public Invalid(IFileStore parent, String name) {
            this.parent = parent;
            this.name = name;
        }

        public IFileStore getParent() {
            return this.parent;
        }

        public String getName() {
            return this.name;
        }

        public String[] childNames(int options, IProgressMonitor monitor) throws CoreException {
            return CDOWorkspaceFileSystem.NO_CHILD_NAMES;
        }

        public IFileStore getChild(String name) {
            return new Invalid((IFileStore)this, name);
        }

        public IFileInfo fetchInfo(int options, IProgressMonitor monitor) throws CoreException {
            throw new UnsupportedOperationException();
        }

        public InputStream openInputStream(int options, IProgressMonitor monitor) throws CoreException {
            throw new UnsupportedOperationException();
        }
    }
}

