/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.multicore.utils;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.uml2.uml.Activity;
import org.eclipse.uml2.uml.BehavioralFeature;
import org.eclipse.uml2.uml.CallOperationAction;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.InstanceValue;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Slot;
import org.polarsys.chess.chessmlprofile.Core.IdentifSlot;
import org.polarsys.chess.chessmlprofile.Predictability.RTComponentModel.CHRtPortSlot;
import org.polarsys.chess.chessmlprofile.Predictability.RTComponentModel.CHRtSpecification;
import org.polarsys.chess.core.profiles.CHESSProfileManager;
import org.polarsys.chess.core.util.uml.ModelError;
import org.polarsys.chess.core.util.uml.UMLUtils;
import org.polarsys.chess.multicore.utils.QueryUtils;
import org.polarsys.chess.multicore.utils.VSLUtils;

public class InstanceQuery {
    public static Package getInstanceSpecPackage(Model umlModel) {
        Package cmpv = CHESSProfileManager.getViewByStereotype((Model)umlModel, (String)"ComponentView");
        cmpv = QueryUtils.getOneResourcePlatformPackage(cmpv);
        return cmpv;
    }

    static boolean isDeferred(CHRtSpecification usedCH) {
        String occKind = usedCH.getOccKind();
        return occKind != null;
    }

    static CHRtSpecification getCHFromSlot(Slot usedPiSlot, Operation operation) {
        if (usedPiSlot == null) {
            return null;
        }
        CHRtPortSlot ch = (CHRtPortSlot)UMLUtils.getStereotypeApplication((Element)usedPiSlot, CHRtPortSlot.class);
        if (ch == null) {
            return null;
        }
        for (CHRtSpecification i : ch.getCH_RtSpecification()) {
            if (i.getContext().equals(operation)) {
                return i;
            }
            if (!UMLUtils.areOperationsEqual((Operation)((Operation)i.getContext()), (Operation)operation, null)) continue;
            return i;
        }
        assert (false);
        return null;
    }

    private static EList<InstanceSpecification> getRiPiLinks(Slot slot) {
        BasicEList riPiLinks = new BasicEList();
        EList allOwnedElements = slot.getOwner().getOwner().allOwnedElements();
        for (Element e : allOwnedElements) {
            boolean b;
            if (!(e instanceof InstanceSpecification)) continue;
            InstanceSpecification f = (InstanceSpecification)e;
            boolean bl = b = f.getClassifiers().size() == 0;
            if (!b) continue;
            riPiLinks.add((Object)f);
        }
        return riPiLinks;
    }

    static Slot getOppositeSlot(Slot slot) throws ModelError {
        EList<InstanceSpecification> riPiLinks = InstanceQuery.getRiPiLinks(slot);
        for (InstanceSpecification l : riPiLinks) {
            EList<InstanceValue> ends = InstanceQuery.getEnds(l);
            if (ends.size() != 2) {
                throw new ModelError("A connector must have exactly 2 ends");
            }
            int i = 0;
            while (i < 2) {
                int j = (i + 1) % 2;
                InstanceValue first = (InstanceValue)ends.get(i);
                boolean b = first.getInstance().equals(slot.getOwningInstance());
                boolean bl = b = b && ((Slot)first.getOwner()).getDefiningFeature().equals(slot.getDefiningFeature());
                if (b) {
                    InstanceValue instanceValue = (InstanceValue)ends.get(j);
                    InstanceSpecification instance = instanceValue.getInstance();
                    Element owner = instanceValue.getOwner();
                    if (owner instanceof Slot) {
                        Slot sOwner = (Slot)owner;
                        for (Slot s : instance.getSlots()) {
                            if (!s.getDefiningFeature().equals(sOwner.getDefiningFeature())) continue;
                            return s;
                        }
                    }
                }
                ++i;
            }
        }
        return null;
    }

    private static EList<InstanceValue> getEnds(InstanceSpecification l) {
        BasicEList ends = new BasicEList();
        for (Element element : l.allOwnedElements()) {
            if (!(element instanceof InstanceValue)) continue;
            InstanceValue iv = (InstanceValue)element;
            ends.add((Object)iv);
        }
        return ends;
    }

    static EList<Slot> getSlotFromPort(CallOperationAction callOp, InstanceSpecification owningInstance) {
        BehavioralFeature specification = callOp.getActivity().getSpecification();
        Operation op = (Operation)specification;
        Constraint c = null;
        block0: for (Constraint rule : op.getClass_().getOwnedRules()) {
            for (Element cE : rule.getConstrainedElements()) {
                if (!(cE instanceof CallOperationAction)) continue;
                CallOperationAction cCE = (CallOperationAction)cE;
                if (!cCE.equals(callOp)) continue block0;
                c = rule;
                continue block0;
            }
        }
        EList<Slot> result = new EList<Slot>();
        if (c == null) {
            for (Slot slot : owningInstance.getSlots()) {
                if (!slot.getDefiningFeature().equals(callOp.getOnPort())) continue;
                result.add((Object)slot);
            }
        } else {
            result = InstanceQuery.portToSlotsByRule(owningInstance, callOp.getOnPort(), c);
        }
        return result;
    }

    static CHRtPortSlot getCHRtPortSlot(Package instPkg, CHRtSpecification dOp) throws ModelError {
        for (Element e : instPkg.allOwnedElements()) {
            CHRtPortSlot pSlot;
            if (!(e instanceof Slot) || (pSlot = (CHRtPortSlot)UMLUtils.getStereotypeApplication((Element)e, CHRtPortSlot.class)) == null) continue;
            for (CHRtSpecification chSPec : pSlot.getCH_RtSpecification()) {
                if (!chSPec.equals(dOp)) continue;
                return pSlot;
            }
        }
        throw new ModelError("Slot for %s does not exist in the instance package", new Object[]{dOp.getContext().getName()});
    }

    private static void getCHRtCommentsfromPort(Port piPort, Operation operation) {
        EList ownedComments = piPort.getOwner().getOwner().getOwnedComments();
        for (Comment comment : ownedComments) {
            CHRtSpecification stereotypeApplication = (CHRtSpecification)UMLUtils.getStereotypeApplication((Element)comment, CHRtSpecification.class);
            if (stereotypeApplication == null) continue;
            Operation context = (Operation)stereotypeApplication.getContext();
            UMLUtils.isOperationEquals((Operation)context, (Operation)operation);
        }
    }

    private static Port getOppositePort(Port riPort) {
        EList ends = riPort.getEnds();
        assert (ends.size() == 1);
        Iterator iterator = ends.iterator();
        if (iterator.hasNext()) {
            ConnectorEnd end = (ConnectorEnd)iterator.next();
            Connector connector = (Connector)end.getOwner();
            ConnectorEnd oppositeEnd = InstanceQuery.getOppositeEnd(connector, end);
            Port oppositePort = (Port)oppositeEnd.getRole();
            return oppositePort;
        }
        return null;
    }

    private static ConnectorEnd getOppositeEnd(Connector connector, ConnectorEnd currentEnd) {
        EList array = connector.getEnds();
        assert (array.size() == 2);
        for (ConnectorEnd end : array) {
            if (end.equals(currentEnd)) continue;
            return end;
        }
        return null;
    }

    static Activity getMethod(CHRtSpecification dOp) {
        try {
            return (Activity)dOp.getContext().getMethods().get(0);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static EList<Slot> portToSlotsByRule(InstanceSpecification self, Port onPort, Constraint rule) {
        BasicEList list = new BasicEList();
        String[] values = rule.getSpecification().stringValue().trim().split(" ");
        ArrayList<int[]> boundsList = new ArrayList<int[]>();
        String[] stringArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            boundsList.add(VSLUtils.getBounds(value));
            ++n2;
        }
        for (Slot slot : self.getSlots()) {
            IdentifSlot id = (IdentifSlot)UMLUtils.getStereotypeApplication((Element)slot, IdentifSlot.class);
            if (id != null && slot.getDefiningFeature() == onPort && VSLUtils.isInBounds(id.getId(), boundsList).booleanValue()) {
                list.add((Object)slot);
                continue;
            }
            if (slot.getDefiningFeature() != onPort) continue;
            list.add((Object)slot);
        }
        return list;
    }
}

