/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.sasheditor.di.contentprovider.utils;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IPageManager;
import org.eclipse.papyrus.infra.core.sasheditor.di.contentprovider.internal.PageManagerImpl;
import org.eclipse.papyrus.infra.core.sasheditor.di.contentprovider.utils.LookupIPageVisitor;
import org.eclipse.papyrus.infra.core.sasheditor.editor.IPage;
import org.eclipse.papyrus.infra.core.sasheditor.editor.IPageVisitor;
import org.eclipse.papyrus.infra.core.sasheditor.editor.ISashWindowsContainer;
import org.eclipse.papyrus.infra.core.sashwindows.di.PageRef;
import org.eclipse.papyrus.infra.core.sashwindows.di.SashModel;
import org.eclipse.papyrus.infra.core.sashwindows.di.SashWindowsMngr;
import org.eclipse.papyrus.infra.core.sashwindows.di.TabFolder;
import org.eclipse.papyrus.infra.core.sashwindows.di.util.DiSwitch;

public class IPageUtils {
    public static Object getRawModel(IPage page) {
        if (page == null) {
            return null;
        }
        Object pageModel = page.getRawModel();
        if (pageModel instanceof PageRef) {
            return ((PageRef)pageModel).getPageIdentifier();
        }
        return pageModel;
    }

    public static IPage lookupModelPage(ISashWindowsContainer container, Object identifier) {
        LookupIPageVisitor visitor = new LookupIPageVisitor(identifier);
        container.visit((IPageVisitor)visitor);
        return visitor.getResult();
    }

    public static Command getMemoizedCloseAllPagesCommand(TransactionalEditingDomain domain, IPageManager pageManager, final Object pageIdentifier) {
        RecordingCommand result = null;
        final PageManagerImpl pageMan = (PageManagerImpl)pageManager;
        final Map<PageRef, TabFolder> pages = IPageUtils.execute(pageMan, new PageManagerImpl.SashModelOperation<Map<PageRef, TabFolder>>(){

            @Override
            public Map<PageRef, TabFolder> execute(SashWindowsMngr sashWindowsManager) {
                return (Map)new DiSwitch<Map<PageRef, TabFolder>>(){
                    private Map<PageRef, TabFolder> pages = new HashMap<PageRef, TabFolder>();

                    @Override
                    public Map<PageRef, TabFolder> defaultCase(EObject object) {
                        for (EObject next : object.eContents()) {
                            this.doSwitch(next);
                        }
                        return this.pages;
                    }

                    @Override
                    public Map<PageRef, TabFolder> casePageRef(PageRef object) {
                        if (object.getPageIdentifier() == pageIdentifier) {
                            this.pages.put(object, object.getParent());
                        }
                        return this.pages;
                    }
                }.doSwitch(sashWindowsManager.getSashModel());
            }
        });
        if (!pages.isEmpty()) {
            final PageManagerImpl.SashModelOperation<Void> removeOp = new PageManagerImpl.SashModelOperation<Void>(){

                @Override
                public Void execute(SashWindowsMngr sashWindowsManager) {
                    SashModel sashModel = sashWindowsManager.getSashModel();
                    for (Map.Entry next : pages.entrySet()) {
                        PageRef page = (PageRef)next.getKey();
                        TabFolder folder = (TabFolder)next.getValue();
                        folder.getChildren().remove((Object)page);
                        sashModel.removeEmptyFolder(folder);
                    }
                    return null;
                }
            };
            result = new RecordingCommand(domain, "Remove Editor Page(s)"){

                protected void doExecute() {
                    IPageUtils.execute(pageMan, removeOp);
                }
            };
        }
        return result;
    }

    private static <T> T execute(PageManagerImpl pageManager, PageManagerImpl.SashModelOperation<T> sashOperation) {
        try {
            return pageManager.execute(sashOperation);
        }
        catch (IllegalAccessException e) {
            throw new IllegalAccessError(e.getLocalizedMessage());
        }
    }
}

