/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.sasheditor.di.contentprovider.commands;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IPageManager;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class CloseAllDiagramsCommand
extends AbstractHandler {
    public void setEnabled(Object evaluationContext) {
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IPageManager pageManager;
        try {
            pageManager = this.getPageManager(event);
        }
        catch (NullPointerException e) {
            return null;
        }
        this.execute(pageManager);
        return null;
    }

    private IPageManager getPageManager(ExecutionEvent event) {
        IEditorPart part = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        IPageManager pageManager = (IPageManager)part.getAdapter(IPageManager.class);
        return pageManager;
    }

    public void execute(IPageManager pageManager) throws ExecutionException {
        boolean atLeastOneOpenPage = false;
        for (Object pageIdentifier : pageManager.allPages()) {
            if (!pageManager.isOpen(pageIdentifier)) continue;
            atLeastOneOpenPage = true;
            break;
        }
        if (!atLeastOneOpenPage) {
            return;
        }
        pageManager.closeAllOpenedPages();
    }
}

