/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.viewersearcher;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.services.viewersearch.impl.AbstractViewerSearcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiagramViewerSearcher
extends AbstractViewerSearcher {
    public Map<Object, Map<Object, Object>> getViewers(Collection<Object> modelElements, Collection<ModelSet> modelSets) {
        HashMap<Object, Map<Object, Object>> results = new HashMap<Object, Map<Object, Object>>();
        for (ModelSet modelSet : modelSets) {
            Map<EObject, Collection<EStructuralFeature.Setting>> references = this.crossReference(modelElements, modelSet);
            for (EObject semanticElement : references.keySet()) {
                for (EStructuralFeature.Setting setting : references.get(semanticElement)) {
                    if (!(setting.getEObject() instanceof View)) continue;
                    Map viewMappings = results.containsKey(modelSet) ? (Map)results.get(modelSet) : new HashMap();
                    viewMappings.put(setting.getEObject(), semanticElement);
                    results.put(modelSet, viewMappings);
                }
            }
        }
        return results;
    }

    private Map<EObject, Collection<EStructuralFeature.Setting>> crossReference(Collection<?> modelElements, ModelSet modelSet) {
        HashMap<EObject, Collection<EStructuralFeature.Setting>> result;
        ECrossReferenceAdapter xrefs = ECrossReferenceAdapter.getCrossReferenceAdapter((Notifier)modelSet);
        if (xrefs == null) {
            result = EcoreUtil.UsageCrossReferencer.findAll(modelElements, (ResourceSet)modelSet);
        } else {
            result = new HashMap<EObject, Collection<EStructuralFeature.Setting>>();
            for (Object next : modelElements) {
                if (!(next instanceof EObject)) continue;
                EObject eObject = (EObject)next;
                result.put(eObject, xrefs.getInverseReferences(eObject));
            }
        }
        return result;
    }
}

