/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.dsml.validation.model.elements.impl;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.util.EDataTypeUniqueEList;
import org.eclipse.papyrus.dsml.validation.model.elements.impl.WrongStereotypeException;
import org.eclipse.papyrus.dsml.validation.model.elements.interfaces.Category;
import org.eclipse.papyrus.dsml.validation.model.elements.interfaces.IValidationRule;
import org.eclipse.papyrus.dsml.validation.model.elements.interfaces.Mode;
import org.eclipse.papyrus.dsml.validation.model.elements.interfaces.Severity;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Stereotype;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidationRuleImpl
implements IValidationRule {
    private static final String ERROR = "Constraint is not stereotyepd with ValidationRule";
    private Constraint constraint;
    private Stereotype stereotype;
    private String contextID;
    private List<String> targets;
    private String id;
    private Integer statusCode;
    private String implementingClass;

    public ValidationRuleImpl(Constraint constraint) throws WrongStereotypeException {
        this.constraint = constraint;
        this.stereotype = constraint.getAppliedStereotype("PapyrusDSMLValidationRule::ValidationRule");
        if (this.stereotype == null) {
            throw new WrongStereotypeException(ERROR);
        }
    }

    public ValidationRuleImpl(Constraint constraint, Category parentCategory) throws WrongStereotypeException {
        this(constraint);
        String qname;
        this.id = constraint.getValue(this.stereotype, "id") == null || constraint.getValue(this.stereotype, "id").equals("") ? (qname = constraint.getQualifiedName().replace("::", ".")) : (String)constraint.getValue(this.stereotype, "id");
        this.implementingClass = String.valueOf(parentCategory.getID()) + "." + this.getName() + "Constraint";
        this.contextID = parentCategory.getID();
        this.targets = new ArrayList<String>();
        if (constraint.getValue(this.stereotype, "target") != null && ((EDataTypeUniqueEList)constraint.getValue(this.stereotype, "target")).size() > 0) {
            for (Object target : (EDataTypeUniqueEList)constraint.getValue(this.stereotype, "target")) {
                if (target == null) continue;
                this.targets.add((String)target);
            }
        }
        this.statusCode = (Integer)constraint.getValue(this.stereotype, "statusCode");
        if (this.statusCode == null) {
            this.statusCode = new Integer(1);
        }
    }

    @Override
    public String getName() {
        return this.constraint.getName();
    }

    @Override
    public String getID() {
        return this.id == null ? (String)this.constraint.getValue(this.stereotype, "id") : this.id;
    }

    @Override
    public Integer getStatusCode() {
        Integer statusCode = (Integer)this.constraint.getValue(this.stereotype, "statusCode");
        return statusCode == null ? new Integer(1) : statusCode;
    }

    @Override
    public Severity getSeverity() {
        Object severityObj = this.constraint.getValue(this.stereotype, "severity");
        if (severityObj instanceof Enumerator) {
            Enumerator severity = (Enumerator)severityObj;
            String severityType = severity.getName();
            if (severityType.compareTo(Severity.INFO.name()) == 0) {
                return Severity.INFO;
            }
            if (severityType.compareTo(Severity.WARNING.name()) == 0) {
                return Severity.WARNING;
            }
            if (severityType.compareTo(Severity.CANCEL.name()) == 0) {
                return Severity.CANCEL;
            }
        }
        return Severity.ERROR;
    }

    @Override
    public String getImplementingClass() {
        return this.implementingClass;
    }

    @Override
    public Mode getMode() {
        Object modeObj = this.constraint.getValue(this.stereotype, "mode");
        if (modeObj instanceof Enumerator) {
            Enumerator mode = (Enumerator)modeObj;
            String modeType = mode.getName();
            if (modeType.compareTo(Mode.Batch.name()) == 0) {
                return Mode.Batch;
            }
            if (modeType.compareTo(Mode.Live.name()) == 0) {
                return Mode.Live;
            }
        }
        return Mode.Batch;
    }

    @Override
    public boolean isEnabledByDefault() {
        return this.constraint.getValue(this.stereotype, "isEnabledByDefault") == null ? true : (Boolean)this.constraint.getValue(this.stereotype, "isEnabledByDefault");
    }

    @Override
    public String getMessage() {
        return (String)this.constraint.getValue(this.stereotype, "message");
    }

    @Override
    public String getDescription() {
        return (String)this.constraint.getValue(this.stereotype, "description");
    }

    @Override
    public List<String> getTargets() {
        return this.targets;
    }

    @Override
    public Constraint getConstraint() {
        return this.constraint;
    }
}

