/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.dsml.validation.model.elements.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.papyrus.dsml.validation.model.elements.impl.CategoryImpl;
import org.eclipse.papyrus.dsml.validation.model.elements.impl.ConstraintCategoryImpl;
import org.eclipse.papyrus.dsml.validation.model.elements.impl.ConstraintProviderImpl;
import org.eclipse.papyrus.dsml.validation.model.elements.impl.ValidationRuleImpl;
import org.eclipse.papyrus.dsml.validation.model.elements.impl.WrongStereotypeException;
import org.eclipse.papyrus.dsml.validation.model.elements.interfaces.Category;
import org.eclipse.papyrus.dsml.validation.model.elements.interfaces.IConstraintProvider;
import org.eclipse.papyrus.dsml.validation.model.elements.interfaces.IConstraintsManager;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Stereotype;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstraintManagerImpl
implements IConstraintsManager {
    private List<IConstraintProvider> constraintsProviders = new ArrayList<IConstraintProvider>();
    private Map<Stereotype, List<Constraint>> constraintsOfStereotype = new HashMap<Stereotype, List<Constraint>>();
    private Map<Constraint, ValidationRuleImpl> validationRuleMap = new HashMap<Constraint, ValidationRuleImpl>();
    private Category primeCategory;
    private IConstraintProvider constraintProvider;

    @Override
    public Map<Constraint, ValidationRuleImpl> getValidationRuleMap() {
        return this.validationRuleMap;
    }

    @Override
    public Map<Stereotype, List<Constraint>> getConstraintsOfStereotype() {
        return this.constraintsOfStereotype;
    }

    public ConstraintManagerImpl(Profile profile) {
        this.extractElements(profile);
    }

    private void extractElements(Profile root) {
        this.createStereotypeToConstraintsMapping(root);
        this.primeCategory = new CategoryImpl(root.getName().toLowerCase(), null);
        this.relateCategoriesWithConstraints((Element)root, this.primeCategory);
    }

    private void relateCategoriesWithConstraints(Element element, Category category) {
        if (element instanceof Profile) {
            ConstraintCategoryImpl subCategory = new ConstraintCategoryImpl(((Profile)element).getName(), category);
            category.getSubcategories().add(subCategory);
            this.constraintProvider = new ConstraintProviderImpl();
            this.constraintProvider.getConstraintsCategories().add(subCategory);
            this.constraintsProviders.add(this.constraintProvider);
            if (((Profile)element).getDefinition() != null) {
                this.constraintProvider.setEPackage(((Profile)element).getDefinition());
            }
            for (NamedElement subElement : ((Profile)element).getOwnedMembers()) {
                if (subElement instanceof Profile) {
                    this.relateCategoriesWithConstraints((Element)subElement, subCategory);
                    continue;
                }
                if (!(subElement instanceof Stereotype) || this.constraintsOfStereotype.get(subElement) == null) continue;
                for (Constraint constraint : this.constraintsOfStereotype.get(subElement)) {
                    try {
                        ValidationRuleImpl rule = new ValidationRuleImpl(constraint, subCategory);
                        this.validationRuleMap.put(constraint, rule);
                        subCategory.getConstraints().add(rule);
                    }
                    catch (WrongStereotypeException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    protected Category createCategory(Category category, NamedElement subElement) {
        CategoryImpl subCategory = new CategoryImpl(String.valueOf(category.getName()) + "." + subElement.getName().toLowerCase(), category);
        return subCategory;
    }

    private void createStereotypeToConstraintsMapping(Profile profile) {
        for (Element element : profile.allOwnedElements()) {
            Namespace contextElement;
            if (!(element instanceof Constraint) || element.getAppliedStereotype("PapyrusDSMLValidationRule::ValidationRule") == null || !((contextElement = ((Constraint)element).getContext()) instanceof Stereotype)) continue;
            if (this.constraintsOfStereotype.keySet().contains(contextElement)) {
                this.constraintsOfStereotype.get(contextElement).add((Constraint)element);
                continue;
            }
            ArrayList<Constraint> constraintsList = new ArrayList<Constraint>();
            constraintsList.add((Constraint)element);
            this.constraintsOfStereotype.put((Stereotype)contextElement, constraintsList);
        }
    }

    @Override
    public List<IConstraintProvider> getConstraintsProviders() {
        return this.constraintsProviders;
    }

    @Override
    public Category getPrimeCategory() {
        return this.primeCategory;
    }
}

