/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.menu.handlers;

import java.util.List;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.CommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.EditCommandRequestWrapper;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.papyrus.infra.core.clipboard.PapyrusClipboard;
import org.eclipse.papyrus.infra.gmfdiag.menu.handlers.AbstractGraphicalCommandHandler;
import org.eclipse.papyrus.infra.gmfdiag.menu.handlers.CopyInDiagramHandler;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CutInDiagramHandler
extends AbstractGraphicalCommandHandler {
    private static final String ACTIVE_SHELL = "activeShell";
    private static final String ACTIVE_FOCUS_CONTROL = "activeFocusControl";

    protected Command getCommand() {
        CompoundCommand cutInDiagramCommand = new CompoundCommand("Cut in Diagram Command");
        Command buildCopy = CopyInDiagramHandler.buildCopyCommand(this.getEditingDomain(), this.getSelectedElements());
        cutInDiagramCommand.add(buildCopy);
        Command buildDelete = this.buildDeleteCommand();
        cutInDiagramCommand.add(buildDelete);
        return cutInDiagramCommand;
    }

    protected Command buildDeleteCommand() {
        TransactionalEditingDomain editingDomain = this.getEditingDomain();
        if (editingDomain == null) {
            return UnexecutableCommand.INSTANCE;
        }
        List<IGraphicalEditPart> editParts = this.getSelectedElements();
        if (editParts.isEmpty()) {
            return UnexecutableCommand.INSTANCE;
        }
        CompositeTransactionalCommand command = new CompositeTransactionalCommand(editingDomain, "Delete From Model");
        for (IGraphicalEditPart editPart : editParts) {
            Command curCommand;
            if (editPart instanceof DiagramEditPart || (curCommand = editPart.getCommand((Request)new EditCommandRequestWrapper((IEditCommandRequest)new DestroyElementRequest(false)))) == null) continue;
            command.compose((IUndoableOperation)new CommandProxy(curCommand));
        }
        if (command.isEmpty()) {
            return UnexecutableCommand.INSTANCE;
        }
        return new ICommandProxy((ICommand)command);
    }

    public void setEnabled(Object evaluationContext) {
        if (evaluationContext instanceof IEvaluationContext) {
            Shell shell;
            Display display;
            IEvaluationContext iEvaluationContext = (IEvaluationContext)evaluationContext;
            Object activeFocusControl = iEvaluationContext.getVariable(ACTIVE_FOCUS_CONTROL);
            Object activeShell = iEvaluationContext.getVariable(ACTIVE_SHELL);
            Control focusControl = null;
            if (activeShell instanceof Shell && (display = (shell = (Shell)activeShell).getDisplay()) != null) {
                focusControl = display.getFocusControl();
            }
            if (activeFocusControl instanceof StyledText || focusControl instanceof Text) {
                this.setBaseEnabled(false);
            } else {
                PapyrusClipboard instance = PapyrusClipboard.getInstance();
                super.setEnabled(evaluationContext);
                PapyrusClipboard.setInstance((PapyrusClipboard)instance);
            }
        }
    }
}

