/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.menu.handlers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart;
import org.eclipse.gmf.runtime.diagram.ui.render.clipboard.AWTClipboardHelper;
import org.eclipse.gmf.runtime.diagram.ui.render.internal.commands.CopyImageCommand;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.commands.INonDirtying;
import org.eclipse.papyrus.commands.util.NonDirtyingUtils;
import org.eclipse.papyrus.commands.wrappers.EMFtoGEFCommandWrapper;
import org.eclipse.papyrus.commands.wrappers.GMFtoGEFCommandWrapper;
import org.eclipse.papyrus.infra.core.clipboard.PapyrusClipboard;
import org.eclipse.papyrus.infra.gmfdiag.common.commands.DefaultDiagramCopyCommand;
import org.eclipse.papyrus.infra.gmfdiag.common.strategy.IStrategy;
import org.eclipse.papyrus.infra.gmfdiag.common.strategy.paste.IPasteStrategy;
import org.eclipse.papyrus.infra.gmfdiag.common.strategy.paste.PasteStrategyManager;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.DiagramEditPartsUtil;
import org.eclipse.papyrus.infra.gmfdiag.menu.handlers.AbstractGraphicalCommandHandler;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CopyInDiagramHandler
extends AbstractGraphicalCommandHandler {
    public static org.eclipse.gef.commands.Command buildCopyCommand(TransactionalEditingDomain editingDomain, Collection<IGraphicalEditPart> selectedElements) {
        PapyrusClipboard papyrusClipboard = PapyrusClipboard.getNewInstance();
        DefaultDiagramCopyCommand defaultDiagramCopyCommand = new DefaultDiagramCopyCommand((EditingDomain)editingDomain, papyrusClipboard, selectedElements);
        org.eclipse.gef.commands.Command result = EMFtoGEFCommandWrapper.wrap((Command)defaultDiagramCopyCommand);
        IDiagramWorkbenchPart activeDiagramWorkbenchPart = DiagramEditPartsUtil.getActiveDiagramWorkbenchPart();
        Diagram diagram = activeDiagramWorkbenchPart.getDiagram();
        DiagramEditPart diagramEditPart = activeDiagramWorkbenchPart.getDiagramEditPart();
        ArrayList<Object> selectedElementModels = new ArrayList<Object>();
        for (IGraphicalEditPart iGraphicalEditPart : selectedElements) {
            selectedElementModels.add(iGraphicalEditPart.getModel());
        }
        MyCopyImageCommand copyImageCommand = new MyCopyImageCommand("Create image to allow paste on system", (View)diagram, selectedElementModels, diagramEditPart);
        if (copyImageCommand.canExecute()) {
            org.eclipse.gef.commands.Command gmFtoGEFCommandWrapper = GMFtoGEFCommandWrapper.wrap((ICommand)copyImageCommand);
            result = NonDirtyingUtils.chain((org.eclipse.gef.commands.Command)result, (org.eclipse.gef.commands.Command)gmFtoGEFCommandWrapper);
        } else {
            copyImageCommand.dispose();
        }
        List allStrategies = PasteStrategyManager.getInstance().getAllStrategies();
        for (IStrategy iStrategy : allStrategies) {
            IPasteStrategy iIPasteStrategy = (IPasteStrategy)iStrategy;
            iIPasteStrategy.prepare(papyrusClipboard, null);
        }
        return result;
    }

    @Override
    protected org.eclipse.gef.commands.Command getCommand() {
        return CopyInDiagramHandler.buildCopyCommand(this.getEditingDomain(), this.getSelectedElements());
    }

    @Override
    public void setEnabled(Object evaluationContext) {
        if (evaluationContext instanceof IEvaluationContext) {
            Shell shell;
            Display display;
            IEvaluationContext iEvaluationContext = (IEvaluationContext)evaluationContext;
            Object activeFocusControl = iEvaluationContext.getVariable("activeFocusControl");
            Object activeShell = iEvaluationContext.getVariable("activeShell");
            Control focusControl = null;
            if (activeShell instanceof Shell && (display = (shell = (Shell)activeShell).getDisplay()) != null) {
                focusControl = display.getFocusControl();
            }
            if (activeFocusControl instanceof StyledText || focusControl instanceof Text) {
                this.setBaseEnabled(false);
            } else {
                PapyrusClipboard instance = PapyrusClipboard.getInstance();
                super.setEnabled(evaluationContext);
                PapyrusClipboard.setInstance((PapyrusClipboard)instance);
            }
        }
    }

    static class MyCopyImageCommand
    extends CopyImageCommand
    implements INonDirtying {
        MyCopyImageCommand(String label, View viewContext, List source, DiagramEditPart diagramEP) {
            super(label, viewContext, source, diagramEP);
        }

        public boolean canExecute() {
            return AWTClipboardHelper.getInstance().isImageCopySupported();
        }
    }
}

