/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.custom.ui.internal.query;

import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.emf.facet.custom.metamodel.custompt.IImage;
import org.eclipse.emf.facet.custom.ui.internal.Activator;
import org.eclipse.emf.facet.custom.ui.internal.ImageProvider;
import org.eclipse.emf.facet.custom.ui.internal.custompt.ImageWrapper;
import org.eclipse.emf.facet.efacet.core.IFacetManager;
import org.eclipse.emf.facet.efacet.core.exception.DerivedTypedElementException;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetAttribute;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetReference;
import org.eclipse.emf.facet.query.java.core.IJavaQuery2;
import org.eclipse.emf.facet.query.java.core.IParameterValueList2;
import org.eclipse.emf.facet.util.swt.imageprovider.IImageProvider;
import org.eclipse.emf.facet.util.swt.imageprovider.IImageProviderFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageQuery
implements IJavaQuery2<EObject, IImage> {
    public IImage evaluate(EObject source, IParameterValueList2 parameterValues, IFacetManager facetManager) throws DerivedTypedElementException {
        IImage result = null;
        ETypedElement sfParam = null;
        if (parameterValues != null) {
            sfParam = (ETypedElement)parameterValues.getParameterValueByName("eStructuralFeature").getValue();
        }
        result = sfParam == null ? ImageQuery.getEObjectImage(source) : ImageQuery.getLinkImage(sfParam);
        return result;
    }

    protected static IImage getEObjectImage(EObject source) {
        ImageWrapper result = null;
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        IItemLabelProvider itemLabelProvider = (IItemLabelProvider)adapterFactory.adapt((Notifier)source, IItemLabelProvider.class);
        if (itemLabelProvider != null) {
            ImageDescriptor imgDescriptor = ExtendedImageRegistry.getInstance().getImageDescriptor((Object)source);
            IImageProvider imgProvider = IImageProviderFactory.DEFAULT.createIImageProvider((Plugin)Activator.getDefault());
            if (imgDescriptor != null) {
                Image image = imgProvider.getImage(imgDescriptor);
                result = new ImageWrapper(image);
            }
        }
        return result;
    }

    private static IImage getLinkImage(ETypedElement sfParam) {
        Image image = null;
        image = sfParam instanceof FacetReference ? ImageProvider.getInstance().getFacetLinkIcon() : (sfParam instanceof EReference ? ImageQuery.getReferenceImage((EReference)sfParam) : (sfParam instanceof FacetAttribute ? ImageProvider.getInstance().getFacetAttributeIcon() : (sfParam instanceof EAttribute ? ImageQuery.getAttributeImage() : ImageProvider.getInstance().getFeatureIcon())));
        return new ImageWrapper(image);
    }

    private static Image getReferenceImage(EReference reference) {
        EReference opposite = reference.getEOpposite();
        Image result = reference.isContainment() ? (opposite == null ? ImageProvider.getInstance().getUnidirectionalAggregIcon() : ImageProvider.getInstance().getAggregIcon()) : (opposite != null && opposite.isContainment() ? ImageProvider.getInstance().getInvAggregIcon() : (opposite == null ? ImageProvider.getInstance().getUnidirectionalLinkIcon() : ImageProvider.getInstance().getLinkIcon()));
        return result;
    }

    private static Image getAttributeImage() {
        return ImageProvider.getInstance().getAttributeIcon();
    }
}

