/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.common.helper.advice;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.commands.core.commands.DuplicateEObjectsCommand;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.DuplicateElementsRequest;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IPageManager;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.utils.BusinessModelResolver;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForResource;
import org.eclipse.papyrus.infra.nattable.common.Activator;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;

public class NatTableDuplicateEditHelperAdvice
extends AbstractEditHelperAdvice {
    protected ICommand getBeforeDuplicateCommand(DuplicateElementsRequest request) {
        Object additional = request.getParameter("Additional_Duplicated_Elements");
        if (!(additional instanceof Set)) {
            return super.getBeforeDuplicateCommand(request);
        }
        Set duplicatedObjects = (Set)additional;
        EObject object = this.getDuplicatedEObject(request);
        if (object == null || object.eResource() == null) {
            return super.getBeforeDuplicateCommand(request);
        }
        ArrayList<Table> tablesToDuplicate = new ArrayList<Table>();
        ResourceSet resourceSet = object.eResource().getResourceSet();
        ECrossReferenceAdapter adapter = ECrossReferenceAdapter.getCrossReferenceAdapter((Notifier)resourceSet);
        if (adapter == null) {
            adapter = new ECrossReferenceAdapter();
            resourceSet.eAdapters().add((Object)adapter);
        }
        Collection settings = adapter.getInverseReferences(object, false);
        for (EStructuralFeature.Setting setting : settings) {
            EObject value = setting.getEObject();
            if (!(value instanceof Table)) continue;
            tablesToDuplicate.add((Table)value);
        }
        TreeIterator it = object.eAllContents();
        while (it.hasNext()) {
            EObject child = (EObject)it.next();
            settings = adapter.getInverseReferences(child, false);
            for (EStructuralFeature.Setting setting : settings) {
                EObject value = setting.getEObject();
                if (!(value instanceof Table)) continue;
                tablesToDuplicate.add((Table)value);
            }
        }
        if (!tablesToDuplicate.isEmpty()) {
            CompositeCommand command = null;
            for (Table TableToDuplicate : tablesToDuplicate) {
                if (duplicatedObjects.contains(TableToDuplicate)) continue;
                if (command == null) {
                    command = new CompositeCommand("", Arrays.asList(new DuplicateTableCommand(request.getEditingDomain(), "Duplicate Table", TableToDuplicate, request.getAllDuplicatedElementsMap())));
                } else {
                    command.add((IUndoableOperation)new DuplicateTableCommand(request.getEditingDomain(), "Duplicate Table", TableToDuplicate, request.getAllDuplicatedElementsMap()));
                }
                duplicatedObjects.add(TableToDuplicate);
            }
            if (command != null) {
                if (super.getBeforeDuplicateCommand(request) != null) {
                    command.add((IUndoableOperation)super.getBeforeDuplicateCommand(request));
                    return command.reduce();
                }
                return command.reduce();
            }
        }
        return super.getBeforeDuplicateCommand(request);
    }

    protected EObject getDuplicatedEObject(DuplicateElementsRequest request) {
        List elementsToBeDuplicated = request.getElementsToBeDuplicated();
        if (elementsToBeDuplicated == null || elementsToBeDuplicated.isEmpty()) {
            return null;
        }
        Object elementToBeDuplicated = elementsToBeDuplicated.get(0);
        if (elementToBeDuplicated instanceof EObject) {
            return (EObject)elementToBeDuplicated;
        }
        return null;
    }

    public Resource getNotationResourceForTable(EObject eObject, TransactionalEditingDomain domain) {
        Object object = BusinessModelResolver.getInstance().getBusinessModel((Object)eObject);
        EObject semanticObject = !(object instanceof EObject) ? eObject : (EObject)object;
        Resource containerResource = semanticObject.eResource();
        if (containerResource == null) {
            return null;
        }
        ResourceSet resourceSet = containerResource.getResourceSet();
        if (resourceSet instanceof ModelSet) {
            ModelSet modelSet = (ModelSet)resourceSet;
            Resource destinationResource = modelSet.getAssociatedResource(semanticObject, "notation", true);
            return destinationResource;
        }
        throw new RuntimeException("Resource Set is not a ModelSet or is null");
    }

    public Resource getDiResourceForTable(EObject eObject, TransactionalEditingDomain domain) {
        Object object = BusinessModelResolver.getInstance().getBusinessModel((Object)eObject);
        EObject semanticObject = !(object instanceof EObject) ? eObject : (EObject)object;
        Resource containerResource = semanticObject.eResource();
        if (containerResource == null) {
            return null;
        }
        ResourceSet resourceSet = containerResource.getResourceSet();
        if (resourceSet instanceof ModelSet) {
            ModelSet modelSet = (ModelSet)resourceSet;
            Resource destinationResource = modelSet.getAssociatedResource(semanticObject, "di", true);
            return destinationResource;
        }
        throw new RuntimeException("Resource Set is not a ModelSet or is null");
    }

    public class DuplicateTableCommand
    extends DuplicateEObjectsCommand {
        private final Table TableToDuplicate;

        public DuplicateTableCommand(TransactionalEditingDomain editingDomain, String label, Table Table2) {
            super(editingDomain, label, Collections.singletonList(Table2));
            this.TableToDuplicate = Table2;
        }

        public DuplicateTableCommand(TransactionalEditingDomain editingDomain, String label, Table Table2, Map allDuplicatedObjectsMap) {
            super(editingDomain, label, Collections.singletonList(Table2), allDuplicatedObjectsMap);
            this.TableToDuplicate = Table2;
        }

        public DuplicateTableCommand(TransactionalEditingDomain editingDomain, String label, Table Table2, Map allDuplicatedObjectsMap, EObject targetContainer) {
            super(editingDomain, label, Collections.singletonList(Table2), allDuplicatedObjectsMap, targetContainer);
            this.TableToDuplicate = Table2;
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
            TableCopier copier = new TableCopier(this.getAllDuplicatedObjectsMap());
            copier.copy((EObject)this.TableToDuplicate);
            copier.copyReferences();
            EObject duplicateTable = (EObject)copier.get(this.TableToDuplicate);
            Resource targetResource = NatTableDuplicateEditHelperAdvice.this.getNotationResourceForTable(((Table)duplicateTable).getContext(), this.getEditingDomain());
            Resource diTargetResource = NatTableDuplicateEditHelperAdvice.this.getDiResourceForTable(((Table)duplicateTable).getContext(), this.getEditingDomain());
            if (targetResource != null) {
                targetResource.getContents().add((Object)duplicateTable);
                if (diTargetResource != null) {
                    try {
                        IPageManager pageManager = ServiceUtilsForResource.getInstance().getIPageManager((Object)diTargetResource);
                        pageManager.addPage((Object)duplicateTable);
                    }
                    catch (ServiceException e) {
                        Activator.log.error((Throwable)e);
                    }
                } else {
                    Activator.log.error("It was not possible to find the di resource where to add the Table page", null);
                }
            } else {
                Activator.log.warn("It was not possible to find the Resource with the target EObject");
                targetResource = this.TableToDuplicate.eResource();
                if (targetResource != null) {
                    Activator.log.error("It was not possible to find the Resource with the source Table", null);
                    targetResource.getContents().add((Object)duplicateTable);
                    if (diTargetResource != null) {
                        try {
                            IPageManager pageManager = ServiceUtilsForResource.getInstance().getIPageManager((Object)diTargetResource);
                            pageManager.addPage((Object)duplicateTable);
                        }
                        catch (ServiceException e) {
                            Activator.log.error((Throwable)e);
                        }
                    } else {
                        Activator.log.error("It was not possible to find the di resource where to add the Table page", null);
                    }
                }
            }
            return CommandResult.newOKCommandResult((Object)this.getAllDuplicatedObjectsMap());
        }

        public boolean canExecute() {
            return true;
        }
    }

    protected class TableCopier
    extends EcoreUtil.Copier {
        private static final long serialVersionUID = -1115934398631109073L;
        private Map<EObject, EObject> semanticObjects;

        public TableCopier(Map<EObject, EObject> semanticObjects) {
            this.semanticObjects = semanticObjects;
        }

        public EObject get(Object arg0) {
            EObject object = (EObject)super.get(arg0);
            if (object == null) {
                object = this.semanticObjects.get(arg0);
            }
            return object;
        }
    }
}

