/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.common.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.papyrus.infra.core.editor.IMultiDiagramEditor;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForIEvaluationContext;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;

public class RenameTableHandler
extends AbstractHandler {
    public static String RenameTableHandler_NewName = "New name:";
    public static String RenameTableHandler_RenameAnExistingTable = "Rename an existing table";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.executeTransaction(event);
        return null;
    }

    private void executeTransaction(ExecutionEvent event) {
        INattableModelManager tableManager;
        try {
            IEvaluationContext context = this.getIEvaluationContext(event);
            tableManager = this.lookupTableManager(context);
        }
        catch (ServiceException e) {
            return;
        }
        if (tableManager == null) {
            return;
        }
        String currentName = tableManager.getTableName();
        String newName = null;
        InputDialog dialog = new InputDialog(Display.getCurrent().getActiveShell(), RenameTableHandler_RenameAnExistingTable, RenameTableHandler_NewName, currentName, null);
        if (dialog.open() == 0) {
            newName = dialog.getValue();
            if (newName == null || newName.length() <= 0) {
                return;
            }
        } else {
            return;
        }
        tableManager.setTableName(newName);
    }

    public String getCommandName() {
        return "Rename Table";
    }

    protected IEvaluationContext getIEvaluationContext(ExecutionEvent event) {
        if (event.getApplicationContext() instanceof IEvaluationContext) {
            return (IEvaluationContext)event.getApplicationContext();
        }
        return null;
    }

    protected INattableModelManager lookupTableManager(IEvaluationContext context) throws ServiceException {
        IEditorPart editor = (IEditorPart)ServiceUtilsForIEvaluationContext.getInstance().getService(IMultiDiagramEditor.class, (Object)context);
        INattableModelManager tableManager = (INattableModelManager)editor.getAdapter(INattableModelManager.class);
        return tableManager;
    }

    protected TransactionalEditingDomain lookupTransactionalEditingDomain(IEvaluationContext context) throws ServiceException {
        return ServiceUtilsForIEvaluationContext.getInstance().getTransactionalEditingDomain((Object)context);
    }

    public void setEnabled(Object evaluationContext) {
        if (!(evaluationContext instanceof IEvaluationContext)) {
            this.setBaseEnabled(false);
            return;
        }
        IEvaluationContext context = (IEvaluationContext)evaluationContext;
        try {
            this.setBaseEnabled(this.lookupTableManager(context) != null);
            return;
        }
        catch (ServiceException serviceException) {
            this.setBaseEnabled(false);
            return;
        }
    }
}

