/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.wizards;

import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.papyrus.uml.diagram.wizards.Messages;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.part.FileEditorInput;

public abstract class ModelCopyWizard
extends Wizard
implements INewWizard {
    private static final String EXT_DI = ".di";
    private static final String EXT_NOTATION = ".notation";
    private static final String EXT_UML = ".uml";
    private IStructuredSelection selection;
    protected String modelName;
    protected String modelLocation;
    protected WizardNewFileCreationPage selectionPage;

    protected ModelCopyWizard(String modelName) {
        this.modelName = modelName;
        this.modelLocation = "/models/examples/";
    }

    protected ModelCopyWizard(String modelName, String modelLocation) {
        this.modelName = modelName;
        this.modelLocation = modelLocation;
    }

    public boolean performFinish() {
        IFile model = this.copyModel(this.modelName);
        if (model == null) {
            return false;
        }
        IWorkbench wb = PlatformUI.getWorkbench();
        IWorkbenchPage page = wb.getActiveWorkbenchWindow().getActivePage();
        try {
            IEditorDescriptor desc = wb.getEditorRegistry().getDefaultEditor(String.valueOf(this.modelName) + EXT_DI);
            FileEditorInput input = new FileEditorInput(model);
            page.openEditor((IEditorInput)input, desc.getId(), false);
        }
        catch (PartInitException e) {
            return false;
        }
        return true;
    }

    public IFile copyModel(String sourceModelName) {
        try {
            IFile model = this.copyFile(String.valueOf(sourceModelName) + EXT_DI);
            this.copyFile(String.valueOf(sourceModelName) + EXT_NOTATION);
            this.copyFile(String.valueOf(sourceModelName) + EXT_UML);
            return model;
        }
        catch (CoreException e) {
            Shell shell = new Shell();
            String reason = e.getMessage();
            if (reason.endsWith(Messages.ModelCopyWizard_AlreadyyExists)) {
                reason = String.valueOf(reason) + "\n" + Messages.ModelCopyWizard_ChooseOtherParentFolder;
            }
            MessageDialog.openError((Shell)shell, (String)Messages.ModelCopyWizard_CannotCreateCopy, (String)reason);
            return null;
        }
    }

    public IFile copyFile(String sourceFileName) throws CoreException {
        IPath destPath = this.selectionPage.getContainerFullPath();
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream(String.valueOf(this.modelLocation) + sourceFileName);
        if (is != null) {
            destPath = destPath.append(sourceFileName);
            IFile destFile = ResourcesPlugin.getWorkspace().getRoot().getFile(destPath);
            destFile.create(is, false, null);
            return destFile;
        }
        throw new CoreException((IStatus)new Status(0, "org.eclipse.papyrus.uml.diagram.wizards", String.format(Messages.ModelCopyWizard_CannotOpenFIle, String.valueOf(this.modelLocation) + sourceFileName)));
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
        this.setWindowTitle(Messages.ModelCopyWizard_CreatePapyrusExample);
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.selectionPage = new WizardNewFileCreationPage(Messages.ModelCopyWizard_CopyModel, this.selection);
        this.selectionPage.setTitle(String.format(Messages.ModelCopyWizard_SelectParentFolder, this.modelName));
        this.selectionPage.setDescription(Messages.ModelCopyWizard_DoNotChangeFileName);
        this.selectionPage.setFileName(this.modelName);
        this.addPage((IWizardPage)this.selectionPage);
    }
}

