/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.diagram.parametric.utils;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.sysml.constraints.ConstraintBlock;
import org.eclipse.papyrus.sysml.constraints.ConstraintProperty;
import org.eclipse.papyrus.uml.diagram.common.commands.SemanticAdapter;
import org.eclipse.papyrus.uml.diagram.common.helper.ElementHelper;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.util.UMLUtil;

public class ConstraintParameterDropHelper
extends ElementHelper {
    public ConstraintParameterDropHelper(TransactionalEditingDomain editDomain) {
        this.editDomain = editDomain;
    }

    public Command getDropConstraintParameter(Property droppedConstraintParameter, Point location, GraphicalEditPart host) {
        return this.getDropConstraintParameterOnPart(droppedConstraintParameter, location, host);
    }

    public Command getDropConstraintParameterOnPart(Property droppedConstraintParameter, Point location, GraphicalEditPart host) {
        if (!this.isValidConstraintParameter(droppedConstraintParameter, this.getHostEObject(host))) {
            return UnexecutableCommand.INSTANCE;
        }
        CreateViewRequest.ViewDescriptor descriptor = new CreateViewRequest.ViewDescriptor((IAdaptable)new SemanticAdapter((EObject)droppedConstraintParameter, null), Node.class, null, true, host.getDiagramPreferencesHint());
        CreateViewRequest createViewRequest = new CreateViewRequest(descriptor);
        createViewRequest.setLocation(location);
        Command viewCreateCommand = host.getCommand((Request)createViewRequest);
        return viewCreateCommand;
    }

    private boolean isValidConstraintParameter(Object object, EObject dropTarget) {
        Type type;
        if (object instanceof Port) {
            return false;
        }
        if (dropTarget instanceof Class && UMLUtil.getStereotypeApplication((Element)((Class)dropTarget), ConstraintBlock.class) != null) {
            return ((Class)dropTarget).getOwnedAttributes().contains(object);
        }
        if (dropTarget instanceof Property && UMLUtil.getStereotypeApplication((Element)((Property)dropTarget), ConstraintProperty.class) != null && (type = ((Property)dropTarget).getType()) instanceof Class && UMLUtil.getStereotypeApplication((Element)((Class)type), ConstraintBlock.class) != null) {
            return ((Class)type).getOwnedAttributes().contains(object);
        }
        return false;
    }

    protected EObject getHostEObject(GraphicalEditPart host) {
        return ViewUtil.resolveSemanticElement((View)((View)host.getModel()));
    }
}

