/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.diagram.parametric.policies;

import java.util.ArrayList;
import org.eclipse.emf.transaction.RunnableWithResult;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.DropObjectsRequest;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.commands.SelectAndExecuteCommand;
import org.eclipse.papyrus.sysml.diagram.parametric.policies.CustomDragDropEditPolicy;
import org.eclipse.papyrus.sysml.diagram.parametric.utils.BlockDropHelper;
import org.eclipse.papyrus.sysml.service.types.element.SysMLElementTypes;
import org.eclipse.papyrus.uml.service.types.element.UMLElementTypes;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class StructureClassifierDropEditPolicy
extends CustomDragDropEditPolicy {
    public Command getDropObjectsCommand(DropObjectsRequest dropRequest) {
        BlockDropHelper helper = new BlockDropHelper(this.getEditingDomain());
        if (dropRequest.getObjects().size() == 1) {
            Command dropAsTypedConstraintProperty;
            Command dropAsTypedProperty;
            Command dropAsTypedValue;
            Command dropAsTypedActorPart;
            Command dropAsTypedReference;
            final ArrayList<Command> commandChoice = new ArrayList<Command>();
            Command dropAsTypedPart = helper.getDropAsStructureItem(dropRequest, (GraphicalEditPart)this.getHost(), (IElementType)SysMLElementTypes.PART_PROPERTY);
            if (dropAsTypedPart != null && dropAsTypedPart.canExecute()) {
                commandChoice.add(dropAsTypedPart);
            }
            if ((dropAsTypedReference = helper.getDropAsStructureItem(dropRequest, (GraphicalEditPart)this.getHost(), (IElementType)SysMLElementTypes.REFERENCE_PROPERTY)) != null && dropAsTypedReference.canExecute()) {
                commandChoice.add(dropAsTypedReference);
            }
            if ((dropAsTypedActorPart = helper.getDropAsStructureItem(dropRequest, (GraphicalEditPart)this.getHost(), (IElementType)SysMLElementTypes.ACTOR_PART_PROPERTY)) != null && dropAsTypedActorPart.canExecute()) {
                commandChoice.add(dropAsTypedActorPart);
            }
            if ((dropAsTypedValue = helper.getDropAsStructureItem(dropRequest, (GraphicalEditPart)this.getHost(), (IElementType)SysMLElementTypes.VALUE_PROPERTY)) != null && dropAsTypedValue.canExecute()) {
                commandChoice.add(dropAsTypedValue);
            }
            if ((dropAsTypedProperty = helper.getDropAsStructureItem(dropRequest, (GraphicalEditPart)this.getHost(), (IElementType)UMLElementTypes.PROPERTY)) != null && dropAsTypedProperty.canExecute()) {
                commandChoice.add(dropAsTypedProperty);
            }
            if ((dropAsTypedConstraintProperty = helper.getDropAsStructureItem(dropRequest, (GraphicalEditPart)this.getHost(), (IElementType)SysMLElementTypes.CONSTRAINT_PROPERTY)) != null && dropAsTypedConstraintProperty.canExecute()) {
                commandChoice.add(dropAsTypedConstraintProperty);
            }
            Command defaultDropCommand = super.getDropObjectsCommand(dropRequest);
            defaultDropCommand.setLabel("Default drop (Show dropped object in diagram)");
            if (defaultDropCommand != null && defaultDropCommand.canExecute()) {
                commandChoice.add(defaultDropCommand);
            }
            if (commandChoice.size() > 1) {
                RunnableWithResult.Impl<ICommand> runnable = new RunnableWithResult.Impl<ICommand>(){

                    public void run() {
                        this.setResult(new SelectAndExecuteCommand("Select drop action for ", PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), commandChoice));
                    }
                };
                Display.getDefault().syncExec((Runnable)runnable);
                ICommand selectCommand = (ICommand)runnable.getResult();
                return new ICommandProxy(selectCommand);
            }
            if (commandChoice.size() == 1) {
                return (Command)commandChoice.get(0);
            }
            return UnexecutableCommand.INSTANCE;
        }
        return super.getDropObjectsCommand(dropRequest);
    }

    protected View getReferenceViewForConnectorEnd() {
        return ViewUtil.getContainerView((View)super.getReferenceViewForConnectorEnd());
    }
}

