/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.diagram.parametric.commands;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientReferenceRelationshipRequest;
import org.eclipse.gmf.runtime.notation.Connector;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.sysml.blocks.Block;
import org.eclipse.papyrus.sysml.blocks.BlocksPackage;
import org.eclipse.papyrus.sysml.blocks.NestedConnectorEnd;
import org.eclipse.papyrus.sysml.diagram.common.utils.ConstraintBlockHelper;
import org.eclipse.papyrus.sysml.diagram.parametric.commands.ReorientReferenceRelationshipRequestWithGraphical;
import org.eclipse.papyrus.sysml.service.types.utils.ConnectorUtils;
import org.eclipse.papyrus.uml.diagram.common.util.CrossReferencerUtil;
import org.eclipse.papyrus.uml.service.types.command.ConnectorReorientCommand;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.StructuredClassifier;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.util.UMLUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomBindingConnectorReorientCommand
extends ConnectorReorientCommand {
    private final EObject source;
    private final EObject target;

    public CustomBindingConnectorReorientCommand(ReorientReferenceRelationshipRequestWithGraphical request) {
        super((ReorientReferenceRelationshipRequest)request);
        this.source = this.reorientDirection == 1 ? request.getNewRelationshipEnd() : request.getReferenceOwner();
        this.target = this.reorientDirection == 1 ? request.getReferenceOwner() : request.getNewRelationshipEnd();
    }

    public boolean canExecute() {
        if (this.source == this.target) {
            return false;
        }
        Object connectorView = this.getRequest().getParameter("graphical_edge");
        if (connectorView instanceof Connector) {
            View sourceView = this.getSourceView();
            View targetView = this.getTargetView();
            if (this.source != null && this.target != null) {
                boolean hasEncapsulationViolation;
                boolean bl = hasEncapsulationViolation = !this.checkEncapsulationCrossing();
                return hasEncapsulationViolation ? false : ConstraintBlockHelper.isConstraintParameter((Element)((Element)this.source), (View)sourceView) || ConstraintBlockHelper.isConstraintParameter((Element)((Element)this.target), (View)targetView);
            }
        }
        return false;
    }

    private boolean checkEncapsulationCrossing() {
        Block stereotypeApplication;
        Type type;
        ConnectorUtils util = new ConnectorUtils();
        List nestedPropertyPath = util.getNestedPropertyPath(this.getSourceView(), this.getTargetView());
        for (Property property : nestedPropertyPath) {
            type = property.getType();
            stereotypeApplication = (Block)UMLUtil.getStereotypeApplication((Element)type, Block.class);
            if (stereotypeApplication == null || !stereotypeApplication.isEncapsulated()) continue;
            return false;
        }
        nestedPropertyPath = util.getNestedPropertyPath(this.getTargetView(), this.getSourceView());
        for (Property property : nestedPropertyPath) {
            type = property.getType();
            stereotypeApplication = (Block)UMLUtil.getStereotypeApplication((Element)type, Block.class);
            if (stereotypeApplication == null || !stereotypeApplication.isEncapsulated()) continue;
            return false;
        }
        return true;
    }

    protected org.eclipse.uml2.uml.Connector getLink() {
        return (org.eclipse.uml2.uml.Connector)this.getConnectorView().getElement();
    }

    protected void replaceOwner(org.eclipse.uml2.uml.Connector connector, StructuredClassifier newOwner) {
        View sourceView = this.getSourceView();
        View targetView = this.getTargetView();
        StructuredClassifier deducedContainer = new ConnectorUtils().deduceContainer(sourceView, targetView);
        if (connector.getOwner() != deducedContainer) {
            super.replaceOwner(connector, deducedContainer);
        }
    }

    private Connector getConnectorView() {
        return (Connector)this.getRequest().getParameter("graphical_edge");
    }

    private View getSourceView() {
        return this.reorientDirection == 1 ? (View)((ReorientReferenceRelationshipRequestWithGraphical)this.getRequest()).getSourceEditPart().getModel() : this.getConnectorView().getSource();
    }

    private View getTargetView() {
        return this.reorientDirection == 2 ? (View)((ReorientReferenceRelationshipRequestWithGraphical)this.getRequest()).getTargetEditPart().getModel() : this.getConnectorView().getTarget();
    }

    protected Property findNewOppositePartWithPort() {
        return null;
    }

    protected Property findNewPartWithPort() {
        return null;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        CommandResult result = super.doExecuteWithResult(monitor, info);
        org.eclipse.uml2.uml.Connector connector = this.getLink();
        if (connector.getEnds().size() == 2) {
            this.updateNestedPropertyPath((ConnectorEnd)connector.getEnds().get(0), this.getSourceView(), this.getTargetView());
            this.updateNestedPropertyPath((ConnectorEnd)connector.getEnds().get(1), this.getTargetView(), this.getSourceView());
        }
        Set<View> memberViewsToDestroy = this.getMemberViewsToDestroy(connector);
        for (View view : memberViewsToDestroy) {
            if (view == this.getConnectorView()) continue;
            View sourceNode = ((Connector)view).getSource();
            View targetNode = ((Connector)view).getTarget();
            EObject sourceElement = sourceNode.getElement();
            EObject targetElement = targetNode.getElement();
            EList ends = connector.getEnds();
            boolean isSameEnds = true;
            for (ConnectorEnd connectorEnd : ends) {
                if (connectorEnd.getRole() == sourceElement || connectorEnd.getRole() == targetElement) continue;
                isSameEnds = false;
                break;
            }
            if (isSameEnds) continue;
            DestroyElementRequest destroyRequest = new DestroyElementRequest(this.getRequest().getEditingDomain(), (EObject)view, false);
            IElementEditService commandProvider = ElementEditServiceUtils.getCommandProvider((Object)view);
            ICommand editCommand = commandProvider.getEditCommand((IEditCommandRequest)destroyRequest);
            editCommand.execute(monitor, info);
        }
        return result;
    }

    protected Set<View> getMemberViewsToDestroy(org.eclipse.uml2.uml.Connector connector) {
        HashSet<View> viewsToDestroy = new HashSet<View>();
        for (View view : CrossReferencerUtil.getCrossReferencingViews((EObject)connector, null)) {
            viewsToDestroy.add(view);
        }
        return viewsToDestroy;
    }

    private void updateNestedPropertyPath(ConnectorEnd connectorEnd, View sourceView, View targetView) {
        ConnectorUtils utils = new ConnectorUtils();
        List nestedPropertyPath = utils.getNestedPropertyPath(sourceView, targetView);
        if (!nestedPropertyPath.isEmpty()) {
            NestedConnectorEnd nestedConnectorEnd = (NestedConnectorEnd)UMLUtil.getStereotypeApplication((Element)connectorEnd, NestedConnectorEnd.class);
            if (nestedConnectorEnd == null) {
                nestedConnectorEnd = (NestedConnectorEnd)UMLUtil.StereotypeApplicationHelper.INSTANCE.applyStereotype((Element)connectorEnd, BlocksPackage.eINSTANCE.getNestedConnectorEnd());
            }
            nestedConnectorEnd.getPropertyPath().clear();
            nestedConnectorEnd.getPropertyPath().addAll((Collection)nestedPropertyPath);
        } else {
            for (EObject stereotypeApplication : connectorEnd.getStereotypeApplications()) {
                if (!NestedConnectorEnd.class.isInstance(stereotypeApplication)) continue;
                EcoreUtil.delete((EObject)stereotypeApplication, (boolean)true);
            }
        }
    }
}

