/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.diagram.parametric;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.services.ViewService;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.AbstractPapyrusGmfCreateDiagramCommandHandler;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.infra.services.edit.utils.GMFCommandUtils;
import org.eclipse.papyrus.infra.viewpoints.policy.ViewPrototype;
import org.eclipse.papyrus.sysml.blocks.Block;
import org.eclipse.papyrus.sysml.diagram.parametric.Activator;
import org.eclipse.papyrus.sysml.service.types.element.SysMLElementTypes;
import org.eclipse.papyrus.uml.diagram.common.commands.SemanticAdapter;
import org.eclipse.papyrus.uml.diagram.composite.part.UMLDiagramEditorPlugin;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.util.UMLUtil;

public class ParametricDiagramCreateCommand
extends AbstractPapyrusGmfCreateDiagramCommandHandler {
    protected EObject canvasDomainElement = null;
    protected static int DEFAULT_MARGIN = 20;
    protected static int DEFAULT_HEIGHT = 600;
    protected static int DEFAULT_WIDTH = 1000;

    protected String getDefaultDiagramName() {
        return "New Parametric Diagram";
    }

    protected String getDiagramNotationID() {
        return "Parametric";
    }

    protected PreferencesHint getPreferenceHint() {
        return Activator.DIAGRAM_PREFERENCES_HINT;
    }

    protected Diagram doCreateDiagram(Resource diagramResource, EObject owner, EObject element, ViewPrototype prototype, String name) {
        Diagram diagram = null;
        if (element instanceof Class) {
            Class cOwner = (Class)element;
            Block block = (Block)UMLUtil.getStereotypeApplication((Element)cOwner, Block.class);
            if (block != null) {
                this.canvasDomainElement = element;
                Package owningPackage = ((Element)element).getNearestPackage();
                diagram = super.doCreateDiagram(diagramResource, owner, (EObject)owningPackage, prototype, name);
            }
        } else if (element instanceof Package) {
            IElementEditService commandService;
            CreateElementRequest request;
            block8: {
                this.canvasDomainElement = null;
                request = new CreateElementRequest((EObject)((Package)element), (IElementType)SysMLElementTypes.BLOCK);
                commandService = ElementEditServiceUtils.getCommandProvider((Object)element);
                if (commandService != null) break block8;
                return null;
            }
            try {
                ICommand createElementCommand = commandService.getEditCommand((IEditCommandRequest)request);
                if (createElementCommand != null && createElementCommand.canExecute()) {
                    EObject block;
                    createElementCommand.execute((IProgressMonitor)new NullProgressMonitor(), null);
                    this.canvasDomainElement = block = GMFCommandUtils.getCommandEObjectResult((ICommand)createElementCommand);
                    diagram = super.doCreateDiagram(diagramResource, owner, (EObject)((Package)element), prototype, name);
                }
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        }
        return diagram;
    }

    protected void initializeDiagram(EObject diagram) {
        if (diagram instanceof Diagram) {
            Diagram currentDiagram = (Diagram)diagram;
            if (this.canvasDomainElement != null) {
                currentDiagram.setElement(this.canvasDomainElement);
                this.initializeDiagramContent(currentDiagram);
            }
        }
    }

    protected void initializeDiagramContent(Diagram diagram) {
        Node view = ViewService.getInstance().createNode((IAdaptable)new SemanticAdapter(this.canvasDomainElement, null), (View)diagram, "shape_sysml_block_as_composite", -1, true, UMLDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
        view.setElement(diagram.getElement());
        Bounds viewBounds = (Bounds)view.getLayoutConstraint();
        viewBounds.setX(DEFAULT_MARGIN);
        viewBounds.setY(DEFAULT_MARGIN);
        viewBounds.setHeight(DEFAULT_HEIGHT);
        viewBounds.setWidth(DEFAULT_WIDTH);
    }

    public boolean isParentReassignable() {
        return false;
    }
}

