/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.internal.repository.tools.tasks;

import java.util.Map;
import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.eclipse.equinox.p2.internal.repository.tools.Messages;
import org.eclipse.equinox.p2.internal.repository.tools.SlicingOptions;
import org.eclipse.osgi.util.NLS;

public class SlicingOption
extends Task {
    SlicingOptions options = new SlicingOptions();

    public SlicingOption() {
        this.options.forceFilterTo(true);
        this.options.considerStrictDependencyOnly(false);
        this.options.everythingGreedy(true);
        this.options.includeOptionalDependencies(true);
        this.options.followOnlyFilteredRequirements(false);
        this.options.installTimeLikeResolution(false);
        this.setIncludeFeatures(true);
    }

    public void setIncludeOptional(boolean optional) {
        this.options.includeOptionalDependencies(optional);
    }

    public void setPlatformFilter(String platformFilter) {
        if (platformFilter == null || platformFilter.trim().equals("")) {
            return;
        }
        if (platformFilter.equalsIgnoreCase("true")) {
            this.options.forceFilterTo(true);
            return;
        }
        if (platformFilter.equalsIgnoreCase("false")) {
            this.options.forceFilterTo(false);
            return;
        }
        StringTokenizer tok = new StringTokenizer(platformFilter, ",");
        if (tok.countTokens() != 3) {
            throw new BuildException(NLS.bind((String)Messages.SlicingOption_invalid_platform, (Object)platformFilter));
        }
        Map filter = this.options.getFilter();
        filter.put("osgi.os", tok.nextToken().trim());
        filter.put("osgi.ws", tok.nextToken().trim());
        filter.put("osgi.arch", tok.nextToken().trim());
        this.options.setFilter(filter);
    }

    public void setIncludeNonGreedy(boolean greed) {
        this.options.everythingGreedy(greed);
    }

    public void setIncludeFeatures(boolean includeFeatures) {
        Map filter = this.options.getFilter();
        filter.put("org.eclipse.update.install.features", String.valueOf(includeFeatures));
        this.options.setFilter(filter);
    }

    public void setFilter(String filterString) {
        if (filterString == null || filterString.trim().equals("")) {
            return;
        }
        Map filter = this.options.getFilter();
        StringTokenizer tok = new StringTokenizer(filterString, ",");
        while (tok.hasMoreTokens()) {
            String rule = tok.nextToken().trim();
            int eqIndex = rule.indexOf(61);
            if (eqIndex == -1) {
                throw new BuildException(NLS.bind((String)Messages.SlicingOption_invalidFilterFormat, (Object)rule));
            }
            filter.put(rule.substring(0, eqIndex), rule.substring(eqIndex + 1));
        }
        this.options.setFilter(filter);
    }

    public void setFollowStrict(boolean strict) {
        this.options.considerStrictDependencyOnly(strict);
    }

    public void setFollowOnlyFilteredRequirements(boolean onlyFiltered) {
        this.options.followOnlyFilteredRequirements(onlyFiltered);
    }

    public void setLatestVersionOnly(boolean latest) {
        this.options.latestVersionOnly(latest);
    }

    public void setResolve(boolean resolve) {
        this.options.installTimeLikeResolution(resolve);
    }

    public SlicingOptions getOptions() {
        return this.options;
    }
}

