/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.internal.repository.tools.tasks;

import java.util.Collection;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import org.apache.tools.ant.BuildException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.internal.repository.tools.AbstractApplication;
import org.eclipse.equinox.p2.internal.repository.tools.Messages;
import org.eclipse.equinox.p2.internal.repository.tools.tasks.AbstractRepositoryTask;
import org.eclipse.equinox.p2.internal.repository.tools.tasks.IUDescription;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoveIUTask
extends AbstractRepositoryTask {
    private static final String CLASSIFIER = "classifier";
    private static final String ID = "id";
    private static final String VERSION = "version";

    public RemoveIUTask() {
        this.application = new RemoveIUApplication();
    }

    public void execute() throws BuildException {
        try {
            if (this.iuTasks == null || this.iuTasks.isEmpty()) {
                return;
            }
            try {
                this.application.initializeRepos(null);
                if (this.application.getCompositeMetadataRepository() == null) {
                    throw new BuildException(Messages.AbstractApplication_no_valid_destinations);
                }
                IMetadataRepository repository = this.application.getDestinationMetadataRepository();
                IArtifactRepository artifacts = this.application.getDestinationArtifactRepository();
                HashSet<IInstallableUnit> toRemove = new HashSet<IInstallableUnit>();
                for (IUDescription iu : this.iuTasks) {
                    IQuery<IInstallableUnit> iuQuery = iu.createQuery();
                    IQueryResult queryResult = repository.query(iuQuery, null);
                    if (queryResult.isEmpty()) {
                        this.getProject().log(NLS.bind((String)Messages.AbstractRepositoryTask_unableToFind, (Object)iu.toString()));
                        continue;
                    }
                    for (IInstallableUnit unit : queryResult) {
                        Collection keys = unit.getArtifacts();
                        Filter filter = null;
                        try {
                            filter = iu.getArtifactFilter();
                        }
                        catch (InvalidSyntaxException invalidSyntaxException) {
                            this.getProject().log(NLS.bind((String)Messages.skippingInvalidFilter, (Object)iu.toString()));
                            continue;
                        }
                        boolean removeMetadata = filter != null ? keys.size() > 0 : true;
                        for (IArtifactKey key : keys) {
                            if (filter == null) {
                                artifacts.removeDescriptor(key);
                                continue;
                            }
                            IArtifactDescriptor[] descriptors = artifacts.getArtifactDescriptors(key);
                            int j = 0;
                            while (j < descriptors.length) {
                                if (filter.match(this.createDictionary(descriptors[j]))) {
                                    artifacts.removeDescriptor(descriptors[j]);
                                } else {
                                    removeMetadata = false;
                                }
                                ++j;
                            }
                        }
                        if (!removeMetadata) continue;
                        toRemove.add(unit);
                    }
                }
                if (toRemove.size() > 0) {
                    repository.removeInstallableUnits(toRemove);
                }
            }
            catch (ProvisionException e) {
                throw new BuildException((Throwable)e);
            }
        }
        finally {
            try {
                ((RemoveIUApplication)this.application).finalizeRepos();
            }
            catch (ProvisionException e) {
                throw new BuildException((Throwable)e);
            }
        }
    }

    private Dictionary<String, Object> createDictionary(IArtifactDescriptor descriptor) {
        Hashtable<String, Object> result = new Hashtable<String, Object>(5);
        result.putAll(descriptor.getProperties());
        IArtifactKey key = descriptor.getArtifactKey();
        result.put(CLASSIFIER, key.getClassifier());
        result.put(ID, key.getId());
        result.put(VERSION, key.getVersion());
        return result;
    }

    protected static class RemoveIUApplication
    extends AbstractApplication {
        protected RemoveIUApplication() {
        }

        public IStatus run(IProgressMonitor monitor) {
            return null;
        }

        public void finalizeRepos() throws ProvisionException {
            super.finalizeRepositories();
        }
    }
}

