/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.internal.repository.tools.tasks;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.internal.p2.jarprocessor.ant.JarProcessorTask;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.internal.repository.tools.Messages;
import org.eclipse.equinox.p2.internal.repository.tools.RecreateRepositoryApplication;
import org.eclipse.equinox.p2.internal.repository.tools.RepositoryDescriptor;
import org.eclipse.equinox.p2.internal.repository.tools.tasks.IUDescription;
import org.eclipse.osgi.util.NLS;

public class ProcessRepoTask
extends Task {
    private URI repository = null;
    private boolean pack = false;
    private boolean repack = false;
    private SigningOptions signing = null;
    private JarProcessorTask jarProcessor = null;

    public void execute() throws BuildException {
        File file = URIUtil.toFile((URI)this.repository);
        if (file == null || !file.exists()) {
            throw new BuildException(NLS.bind((String)Messages.ProcessRepo_must_be_local, (Object)this.repository.toString()));
        }
        if (this.pack | this.repack | this.signing != null) {
            if (this.jarProcessor == null) {
                this.jarProcessor = new JarProcessorTask();
            }
            if (this.signing != null) {
                this.jarProcessor.setAlias(this.signing.alias);
                this.jarProcessor.setKeypass(this.signing.keypass);
                this.jarProcessor.setKeystore(this.signing.keystore);
                this.jarProcessor.setStorepass(this.signing.storepass);
                this.jarProcessor.setUnsign(this.signing.unsign);
                if (this.signing.alias != null && this.signing.alias.length() > 0 && !this.signing.alias.startsWith("${")) {
                    this.jarProcessor.setSign(true);
                }
            }
            this.jarProcessor.setPack(this.pack);
            this.jarProcessor.setNormalize(this.repack);
            this.jarProcessor.setInputFolder(new File(this.repository));
            this.jarProcessor.setProject(this.getProject());
            this.jarProcessor.execute();
        }
        this.recreateRepository();
    }

    private void recreateRepository() {
        RepositoryDescriptor descriptor = new RepositoryDescriptor();
        descriptor.setAppend(true);
        descriptor.setFormat(null);
        descriptor.setKind("artifact");
        descriptor.setLocation(this.repository);
        RecreateRepositoryApplication application = new RecreateRepositoryApplication();
        application.setArtifactRepository(descriptor);
        try {
            application.run((IProgressMonitor)new NullProgressMonitor());
        }
        catch (ProvisionException e) {
            e.printStackTrace();
        }
    }

    public void setRepositoryPath(String repository) {
        try {
            this.repository = URIUtil.fromString((String)repository);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.ProcessRepo_location_not_url, (Object)repository));
        }
    }

    public void setPack(boolean pack) {
        this.pack = pack;
    }

    public void setNormalize(boolean normalize) {
        this.repack = normalize;
    }

    public void addConfiguredSign(SigningOptions options) {
        this.signing = options;
    }

    public void addConfiguredPlugin(IUDescription iu) {
        String path;
        File repo;
        File plugin;
        if (this.jarProcessor == null) {
            this.jarProcessor = new JarProcessorTask();
        }
        if (!(plugin = new File(repo = new File(this.repository), path = "plugins/" + iu.getId() + '_' + iu.getVersion())).exists()) {
            plugin = new File(repo, String.valueOf(path) + ".jar");
        }
        if (plugin.exists()) {
            this.jarProcessor.addInputFile(plugin);
        }
    }

    public void addConfiguredFeature(IUDescription iu) {
        String path;
        File repo;
        File feature;
        if (this.jarProcessor == null) {
            this.jarProcessor = new JarProcessorTask();
        }
        if (!(feature = new File(repo = new File(this.repository), path = "features/" + iu.getId() + '_' + iu.getVersion())).exists()) {
            feature = new File(repo, String.valueOf(path) + ".jar");
        }
        if (feature.exists()) {
            this.jarProcessor.addInputFile(feature);
        }
    }

    public static class SigningOptions {
        public String alias;
        public String keystore;
        public String storepass;
        public String keypass;
        public boolean unsign;

        public void setAlias(String alias) {
            this.alias = alias;
        }

        public void setKeystore(String keystore) {
            this.keystore = keystore;
        }

        public void setKeypass(String keypass) {
            this.keypass = keypass;
        }

        public void setStorepass(String storepass) {
            this.storepass = storepass;
        }

        public void setUnsign(String unsign) {
            this.unsign = Boolean.valueOf(unsign);
        }
    }
}

