/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.internal.repository.tools.tasks;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.internal.repository.mirroring.IArtifactMirrorLog;
import org.eclipse.equinox.p2.internal.repository.tools.Messages;
import org.eclipse.equinox.p2.internal.repository.tools.MirrorApplication;
import org.eclipse.equinox.p2.internal.repository.tools.tasks.AbstractRepositoryTask;
import org.eclipse.equinox.p2.internal.repository.tools.tasks.AntMirrorLog;
import org.eclipse.equinox.p2.internal.repository.tools.tasks.ArtifactDescription;
import org.eclipse.equinox.p2.internal.repository.tools.tasks.ComparatorDescription;
import org.eclipse.equinox.p2.internal.repository.tools.tasks.SlicingOption;
import org.eclipse.equinox.p2.internal.repository.tools.tasks.TaskHelper;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MirrorTask
extends AbstractRepositoryTask {
    private File mirrorLog;
    private ComparatorDescription comparator;
    private boolean ignoreErrors = false;

    public MirrorTask() {
        this.application = new MirrorApplication();
    }

    public void execute() throws BuildException {
        try {
            if (this.mirrorLog != null) {
                ((MirrorApplication)this.application).setLog(this.mirrorLog);
            } else {
                ((MirrorApplication)this.application).setLog((IArtifactMirrorLog)new AntMirrorLog((Object)this));
            }
            if (this.comparator != null) {
                ((MirrorApplication)this.application).setCompare(true);
                if (this.comparator.getBaseline() != null) {
                    ((MirrorApplication)this.application).setBaseline(this.comparator.getBaseline().getDescriptor().getRepoLocation());
                }
                if (this.comparator.getComparator() != null) {
                    ((MirrorApplication)this.application).setComparatorID(this.comparator.getComparator());
                }
                if (this.comparator.getComparatorLog() != null) {
                    ((MirrorApplication)this.application).setComparatorLog(this.comparator.getComparatorLog());
                }
                ((MirrorApplication)this.application).setComparatorExclusions(this.createCompareExclusions());
            }
            this.prepareSourceRepos();
            this.application.initializeRepos(null);
            List<IInstallableUnit> ius = this.prepareIUs();
            this.application.setSourceIUs(ius);
            IStatus result = this.application.run(null);
            if (!this.ignoreErrors && result.matches(4)) {
                throw new BuildException(TaskHelper.statusToString(result, 4, null).toString());
            }
        }
        catch (ProvisionException e) {
            throw new BuildException((Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new BuildException((Throwable)e);
        }
    }

    private IQuery<IArtifactDescriptor> createCompareExclusions() {
        if (this.comparator == null || this.comparator.getExcluded() == null) {
            return null;
        }
        List<ArtifactDescription> artifacts = this.comparator.getExcluded();
        ArrayList<IQuery<IArtifactDescriptor>> queries = new ArrayList<IQuery<IArtifactDescriptor>>();
        for (ArtifactDescription artifactDescription : artifacts) {
            queries.add(artifactDescription.createDescriptorQuery());
        }
        if (queries.size() == 1) {
            return (IQuery)queries.get(0);
        }
        return QueryUtil.createCompoundQuery(queries, (boolean)false);
    }

    public SlicingOption createSlicingOptions() {
        SlicingOption options = new SlicingOption();
        ((MirrorApplication)this.application).setSlicingOptions(options.getOptions());
        return options;
    }

    public ComparatorDescription createComparator() {
        if (this.comparator != null) {
            throw new BuildException(Messages.exception_onlyOneComparator);
        }
        this.comparator = new ComparatorDescription();
        return this.comparator;
    }

    public void setLog(String value) {
        this.mirrorLog = new File(value);
    }

    public void setIgnoreErrors(boolean value) {
        this.ignoreErrors = value;
        ((MirrorApplication)this.application).setIgnoreErrors(value);
    }

    public void setRaw(boolean value) {
        ((MirrorApplication)this.application).setRaw(value);
    }

    public void setVerbose(boolean value) {
        ((MirrorApplication)this.application).setVerbose(value);
    }

    public void setValidate(boolean value) {
        ((MirrorApplication)this.application).setValidate(value);
    }

    public void setIncludePacked(boolean value) {
        ((MirrorApplication)this.application).setIncludePacked(value);
    }

    public void setReferences(boolean value) {
        ((MirrorApplication)this.application).setReferences(value);
    }
}

