/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.views.providers.outline;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.business.api.query.DDiagramElementQuery;
import org.eclipse.sirius.diagram.ui.business.api.provider.AbstractDDiagramElementLabelItemProvider;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

public class OutlineLabelProvider
extends LabelProvider
implements IFontProvider {
    private AdapterFactory factory = DiagramUIPlugin.getPlugin().getItemProvidersAdapterFactory();

    public Image getImage(Object element) {
        Image result = null;
        if (element instanceof DSemanticDecorator) {
            result = this.getImage((DSemanticDecorator)element);
        } else if (element instanceof AbstractDDiagramElementLabelItemProvider) {
            result = this.getImage((AbstractDDiagramElementLabelItemProvider)((Object)element));
        }
        return result;
    }

    private Image getImage(AbstractDDiagramElementLabelItemProvider element) {
        ImageDescriptor descriptor = ExtendedImageRegistry.getInstance().getImageDescriptor(element.getImage(element.getTarget()));
        if (descriptor == null) {
            descriptor = ImageDescriptor.getMissingImageDescriptor();
        }
        Image result = DiagramUIPlugin.getPlugin().getImage(descriptor);
        Option<DDiagramElement> optionTarget = element.getDiagramElementTarget();
        if (optionTarget.some() && new DDiagramElementQuery((DDiagramElement)optionTarget.get()).isLabelHidden()) {
            ImageDescriptor decoratorDescriptor = ExtendedImageRegistry.getInstance().getImageDescriptor(DiagramUIPlugin.INSTANCE.getImage("full/decorator/hidden"));
            DecorationOverlayIcon finalDescriptor = new DecorationOverlayIcon(result, decoratorDescriptor, 0);
            result = DiagramUIPlugin.getPlugin().getImage((ImageDescriptor)finalDescriptor);
        }
        return result;
    }

    private Image getImage(DSemanticDecorator element) {
        IItemLabelProvider labelProvider;
        Image result = null;
        EObject target = element.getTarget();
        if (target != null && (labelProvider = (IItemLabelProvider)this.factory.adapt((Notifier)target, IItemLabelProvider.class)) != null) {
            DecorationOverlayIcon finalDescriptor;
            ImageDescriptor decoratorDescriptor;
            ImageDescriptor descriptor = ExtendedImageRegistry.getInstance().getImageDescriptor(labelProvider.getImage((Object)target));
            if (descriptor == null) {
                descriptor = ImageDescriptor.getMissingImageDescriptor();
            }
            result = DiagramUIPlugin.getPlugin().getImage(descriptor);
            if (element instanceof DEdge) {
                decoratorDescriptor = ExtendedImageRegistry.getInstance().getImageDescriptor(DiagramUIPlugin.INSTANCE.getImage("full/decorator/DEdge"));
                finalDescriptor = new DecorationOverlayIcon(result, decoratorDescriptor, 2);
                result = DiagramUIPlugin.getPlugin().getImage((ImageDescriptor)finalDescriptor);
                result = this.computeFoldDecorator(result, (DEdge)element);
            }
            if (element instanceof DDiagramElement && new DDiagramElementQuery((DDiagramElement)element).isHidden()) {
                decoratorDescriptor = ExtendedImageRegistry.getInstance().getImageDescriptor(DiagramUIPlugin.INSTANCE.getImage("full/decorator/hidden"));
                finalDescriptor = new DecorationOverlayIcon(result, decoratorDescriptor, 0);
                result = DiagramUIPlugin.getPlugin().getImage((ImageDescriptor)finalDescriptor);
            }
        }
        return result;
    }

    private Image computeFoldDecorator(Image baseImage, DEdge edge) {
        if (new DDiagramElementQuery((DDiagramElement)edge).isFolded()) {
            ImageDescriptor foldDescription = ExtendedImageRegistry.getInstance().getImageDescriptor(DiagramUIPlugin.INSTANCE.getImage("full/decorator/fold"));
            DecorationOverlayIcon finalFoldDescriptor = new DecorationOverlayIcon(baseImage, foldDescription, 1);
            return DiagramUIPlugin.getPlugin().getImage((ImageDescriptor)finalFoldDescriptor);
        }
        return baseImage;
    }

    public String getText(Object element) {
        String result = null;
        if (element instanceof DSemanticDecorator) {
            IItemLabelProvider labelProvider;
            EObject target = ((DSemanticDecorator)element).getTarget();
            if (target != null && (labelProvider = (IItemLabelProvider)this.factory.adapt((Notifier)target, IItemLabelProvider.class)) != null) {
                result = labelProvider.getText((Object)target);
            }
        } else if (element instanceof AbstractDDiagramElementLabelItemProvider) {
            result = ((AbstractDDiagramElementLabelItemProvider)((Object)element)).getText(((AbstractDDiagramElementLabelItemProvider)((Object)element)).getTarget());
        }
        return result;
    }

    public Font getFont(Object element) {
        Option<DDiagramElement> optionTarget;
        Font result = JFaceResources.getDefaultFont();
        if (element instanceof DDiagramElement) {
            DDiagramElement vpe = (DDiagramElement)element;
            if (!vpe.isVisible()) {
                result = JFaceResources.getFontRegistry().getItalic("org.eclipse.jface.defaultfont");
            }
        } else if (element instanceof AbstractDDiagramElementLabelItemProvider && (optionTarget = ((AbstractDDiagramElementLabelItemProvider)((Object)element)).getDiagramElementTarget()).some() && new DDiagramElementQuery((DDiagramElement)optionTarget.get()).isLabelHidden()) {
            result = JFaceResources.getFontRegistry().getItalic("org.eclipse.jface.defaultfont");
        }
        return result;
    }
}

