/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.print;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.common.ui.action.actions.IPrintActionHelper;
import org.eclipse.gmf.runtime.common.ui.services.editor.EditorService;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramRootEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IDiagramPreferenceSupport;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditor;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramGraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.printing.actions.DefaultPrintActionHelper;
import org.eclipse.gmf.runtime.diagram.ui.printing.internal.util.SWTDiagramPrinter;
import org.eclipse.gmf.runtime.diagram.ui.printing.render.actions.EnhancedPrintActionHelper;
import org.eclipse.gmf.runtime.diagram.ui.printing.render.internal.DiagramUIPrintingRenderDebugOptions;
import org.eclipse.gmf.runtime.diagram.ui.printing.render.internal.DiagramUIPrintingRenderPlugin;
import org.eclipse.gmf.runtime.diagram.ui.printing.util.DiagramPrinterUtil;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.IMapMode;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.sirius.diagram.ui.tools.internal.print.SiriusRenderedDiagramPrinter;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;

public class SiriusEnhancedPrintActionHelper
implements IPrintActionHelper {
    public void doPrint(IWorkbenchPart workbenchPart) {
        IMapMode mapMode;
        DiagramEditor diagramEditor = null;
        if (!(workbenchPart instanceof DiagramEditor)) {
            Log.error((Plugin)DiagramUIPrintingRenderPlugin.getInstance(), (int)4, (String)"Invalid IWorkbenchPart");
            IllegalArgumentException e = new IllegalArgumentException("Invalid IWorkbenchPart.");
            Trace.throwing((Plugin)DiagramUIPrintingRenderPlugin.getInstance(), (String)DiagramUIPrintingRenderDebugOptions.EXCEPTIONS_THROWING, EnhancedPrintActionHelper.class, (String)"doPrint()", (Throwable)e);
            throw e;
        }
        diagramEditor = (DiagramEditor)workbenchPart;
        IDiagramGraphicalViewer viewer = diagramEditor.getDiagramGraphicalViewer();
        RootEditPart rootEP = viewer == null ? null : viewer.getRootEditPart();
        PreferencesHint preferencesHint = rootEP instanceof IDiagramPreferenceSupport ? ((IDiagramPreferenceSupport)rootEP).getPreferencesHint() : PreferencesHint.USE_DEFAULTS;
        IMapMode iMapMode = mapMode = rootEP instanceof DiagramRootEditPart ? ((DiagramRootEditPart)rootEP).getMapMode() : MapModeUtil.getMapMode();
        if (Platform.getOS().startsWith("win32") && Platform.getOSArch().equals("x86")) {
            DiagramPrinterUtil.printWithSettings((IEditorPart)diagramEditor, this.createDiagramMap(), (SWTDiagramPrinter)new SiriusRenderedDiagramPrinter(preferencesHint, mapMode));
        } else {
            DefaultPrintActionHelper.doRun((IEditorPart)diagramEditor, (SWTDiagramPrinter)new SiriusRenderedDiagramPrinter(preferencesHint, mapMode));
        }
    }

    private Map<String, Diagram> createDiagramMap() {
        HashMap<String, Diagram> diagramMap = new HashMap<String, Diagram>();
        List diagramEditors = EditorService.getInstance().getRegisteredEditorParts();
        for (Object obj : diagramEditors) {
            IFile file;
            if (!(obj instanceof DiagramEditor)) continue;
            DiagramEditor dEditor = (DiagramEditor)obj;
            String diagramName = null;
            IEditorInput editorInput = dEditor.getEditorInput();
            diagramName = dEditor.getPartName();
            if (diagramName == null) {
                diagramName = dEditor.getTitle();
            }
            if ((file = (IFile)editorInput.getAdapter(IFile.class)) != null) {
                diagramName = String.valueOf(file.getFullPath().toOSString()) + "#" + diagramName;
            }
            if (diagramName == null) {
                diagramName = dEditor.getDiagram().getName();
            }
            diagramName = this.makeNameUnique(diagramName, diagramMap.keySet());
            diagramMap.put(diagramName, dEditor.getDiagram());
        }
        return diagramMap;
    }

    private String makeNameUnique(String name, Set<String> existingNames) {
        String result = name;
        if (existingNames.contains(result)) {
            result = this.makeNameUnique(result, existingNames, 1);
        }
        return result;
    }

    private String makeNameUnique(String name, Set<String> existingNames, int nbIteration) {
        String result = String.valueOf(name) + " (" + nbIteration + ")";
        if (existingNames.contains(result)) {
            result = this.makeNameUnique(name, existingNames, nbIteration + 1);
        }
        return result;
    }
}

