/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.menu;

import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gmf.runtime.common.ui.action.ActionMenuManager;
import org.eclipse.gmf.runtime.common.ui.action.global.GlobalActionId;
import org.eclipse.gmf.runtime.common.ui.services.action.contributionitem.ContributionItemService;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.providers.DiagramContextMenuProvider;
import org.eclipse.gmf.runtime.diagram.ui.services.layout.AbstractLayoutEditPartProvider;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.tools.api.preferences.SiriusDiagramPreferencesKeys;
import org.eclipse.sirius.diagram.ui.tools.internal.actions.delete.DeleteFromModelWithHookAction;
import org.eclipse.sirius.diagram.ui.tools.internal.editor.tabbar.actions.ColorPropertyContributionItem;
import org.eclipse.sirius.diagram.ui.tools.internal.layout.provider.ArrangeAllOnlyLayoutProvider;
import org.eclipse.sirius.diagram.ui.tools.internal.layout.provider.LayoutService;
import org.eclipse.sirius.viewpoint.SiriusPlugin;
import org.eclipse.ui.IWorkbenchPart;

public class DiagramEditorContextMenuProvider
extends DiagramContextMenuProvider {
    private static final String PIN_GROUP = "pinGroup";
    private static final String FILTER_FORMAT_GROUP = "filterFormatGroup";
    private static final String ARRANGE_MENU_ERROR = "Arrange menu is not renamed in Layout";
    private IWorkbenchPart part;
    private DeleteFromModelWithHookAction deleteAction;

    public DiagramEditorContextMenuProvider(IWorkbenchPart part, EditPartViewer viewer) {
        super(part, viewer);
        this.part = part;
        this.deleteAction = new DeleteFromModelWithHookAction(part);
        this.deleteAction.init();
    }

    public void dispose() {
        if (this.deleteAction != null) {
            this.deleteAction.dispose();
            this.deleteAction = null;
        }
        super.dispose();
    }

    public void buildContextMenu(final IMenuManager menu) {
        this.getViewer().flush();
        try {
            TransactionUtil.getEditingDomain((EObject)((EObject)this.getViewer().getContents().getModel())).runExclusive(new Runnable(){

                @Override
                public void run() {
                    IContributionItem item2;
                    IContributionItem item1;
                    ContributionItemService.getInstance().contributeToPopupMenu((IMenuManager)DiagramEditorContextMenuProvider.this, DiagramEditorContextMenuProvider.this.part);
                    menu.remove("deleteFromModelAction");
                    DiagramEditorContextMenuProvider.this.updateFormatMenu(menu);
                    IMenuManager manager = menu.findMenuUsingPath("editMenu");
                    IContributionItem find = manager.find("deleteFromGroup");
                    if (find != null) {
                        manager.appendToGroup("deleteFromGroup", (IAction)DiagramEditorContextMenuProvider.this.deleteAction);
                    } else {
                        manager.add((IAction)DiagramEditorContextMenuProvider.this.deleteAction);
                    }
                    if (DiagramEditorContextMenuProvider.this.clipboardSupportOnlyOnNote() && DiagramEditorContextMenuProvider.this.hasViewOfDDiagramElementSelected()) {
                        manager.remove(GlobalActionId.CUT);
                        manager.remove(GlobalActionId.COPY);
                        manager.remove(GlobalActionId.PASTE);
                    }
                    if ((item1 = menu.find("arrangeBorderedNodesAction")) != null) {
                        menu.remove(item1);
                        IMenuManager arrangeMenu = menu.findMenuUsingPath("arrangeMenu");
                        DiagramEditorContextMenuProvider.this.updateArrangeMenuName(arrangeMenu);
                        arrangeMenu.insertAfter("toolbarArrangeAllAction", item1);
                    }
                    DiagramEditorContextMenuProvider.this.moveArrangeMenuForDiagramElements(menu);
                    IContributionItem item3 = menu.find("selectHiddenElementsAction");
                    if (item3 != null) {
                        menu.remove(item3);
                        menu.insertAfter(DiagramEditorContextMenuProvider.FILTER_FORMAT_GROUP, item3);
                    }
                    if ((item2 = menu.find("newCopyToImageAction")) != null) {
                        menu.remove(item2);
                        menu.insertAfter(DiagramEditorContextMenuProvider.FILTER_FORMAT_GROUP, item2);
                    }
                }
            });
        }
        catch (InterruptedException interruptedException) {}
    }

    private boolean clipboardSupportOnlyOnNote() {
        return Platform.getPreferencesService().getBoolean("org.eclipse.sirius.diagram", SiriusDiagramPreferencesKeys.PREF_CLIPBOOARD_SUPPORT_ONLY_ON_NOTE.name(), false, null);
    }

    private boolean hasViewOfDDiagramElementSelected() {
        boolean hasViewOfDDiagramElementSelected = false;
        List selectedEditParts = this.getViewer().getSelectedEditParts();
        for (Object object : selectedEditParts) {
            IGraphicalEditPart graphicalEditPart;
            EObject semanticElement;
            if (!(object instanceof IGraphicalEditPart) || !((semanticElement = (graphicalEditPart = (IGraphicalEditPart)object).resolveSemanticElement()) instanceof DDiagramElement)) continue;
            hasViewOfDDiagramElementSelected = true;
            break;
        }
        return hasViewOfDDiagramElementSelected;
    }

    private void updateFormatMenu(IMenuManager menu) {
        IContributionItem item;
        IMenuManager manager2 = menu.findMenuUsingPath("formatMenu");
        if (manager2 != null && (item = manager2.findUsingPath("fillColorContributionItem")) != null) {
            manager2.remove("fillColorContributionItem");
            manager2.remove("fontColorContributionItem");
            manager2.remove("lineColorContributionItem");
            manager2.insertAfter("fontDialogAction", (IContributionItem)ColorPropertyContributionItem.createFillColorContributionItem(this.part.getSite().getPage()));
            ColorPropertyContributionItem fontColorContributionItem = ColorPropertyContributionItem.createFontColorContributionItem(this.part.getSite().getPage());
            manager2.insertAfter("fillColorContributionItem", (IContributionItem)fontColorContributionItem);
            manager2.insertAfter("fontColorContributionItem", (IContributionItem)ColorPropertyContributionItem.createLineColorContributionItem(this.part.getSite().getPage()));
        }
    }

    private void moveArrangeMenuForDiagramElements(IMenuManager menu) {
        IMenuManager arrangeMenu;
        IMenuManager formatMenu = menu.findMenuUsingPath("formatMenu");
        if (formatMenu != null && (arrangeMenu = formatMenu.findMenuUsingPath("arrangeMenu")) != null) {
            IContributionItem unpinItem;
            IContributionItem pinItem;
            this.updateArrangeMenuEnableActions(arrangeMenu, this.getViewer().getSelection());
            this.updateArrangeMenuName(arrangeMenu);
            IContributionItem pinSeparator = formatMenu.find(PIN_GROUP);
            if (pinSeparator != null) {
                formatMenu.remove(pinSeparator);
                arrangeMenu.add(pinSeparator);
            }
            if ((pinItem = formatMenu.find("pinElementsAction")) != null) {
                formatMenu.remove(pinItem);
                arrangeMenu.add(pinItem);
            }
            if ((unpinItem = formatMenu.find("unpinElementsAction")) != null) {
                formatMenu.remove(unpinItem);
                arrangeMenu.add(unpinItem);
            }
            formatMenu.remove((IContributionItem)arrangeMenu);
            menu.insertAfter(FILTER_FORMAT_GROUP, (IContributionItem)arrangeMenu);
        }
    }

    private void updateArrangeMenuEnableActions(IMenuManager arrangeMenu, ISelection selection) {
        IGraphicalEditPart graphicalElement = null;
        if (selection instanceof IStructuredSelection) {
            IGraphicalEditPart diagramEditPart;
            AbstractLayoutEditPartProvider layoutNodeProvider;
            RootEditPart root;
            Iterator iterator = ((IStructuredSelection)selection).iterator();
            while (iterator.hasNext() && graphicalElement == null) {
                Object next = iterator.next();
                if (!(next instanceof IGraphicalEditPart)) continue;
                graphicalElement = (IGraphicalEditPart)next;
            }
            if (graphicalElement != null && (IGraphicalEditPart)(root = graphicalElement.getRoot()).getChildren().iterator().next() != null && (layoutNodeProvider = LayoutService.getProvider(diagramEditPart = (IGraphicalEditPart)root.getChildren().iterator().next()).getLayoutNodeProvider(diagramEditPart)) instanceof ArrangeAllOnlyLayoutProvider) {
                this.disableArrangeSelectionActionFromArrangeMenu(arrangeMenu);
            }
        }
    }

    private void disableArrangeSelectionActionFromArrangeMenu(IMenuManager arrangeMenu) {
        int i = 0;
        while (i < arrangeMenu.getItems().length) {
            ActionContributionItem iContributionItem;
            if (arrangeMenu.getItems()[i] instanceof ActionContributionItem && "arrangeSelectionAction".equals((iContributionItem = (ActionContributionItem)arrangeMenu.getItems()[i]).getId())) {
                iContributionItem.getAction().setEnabled(false);
            }
            ++i;
        }
    }

    private void updateArrangeMenuName(IMenuManager arrangeMenu) {
        try {
            Class<?> arrangeMenuClass = arrangeMenu.getClass();
            Field field = arrangeMenuClass.getDeclaredField("realMenuManager");
            field.setAccessible(true);
            Object realMenuManager = field.get(arrangeMenu);
            if (realMenuManager instanceof ActionMenuManager) {
                ((ActionMenuManager)realMenuManager).getDefaultAction().setText("Layout");
            }
        }
        catch (SecurityException e) {
            SiriusPlugin.getDefault().error(ARRANGE_MENU_ERROR, (Throwable)e);
        }
        catch (NoSuchFieldException e) {
            SiriusPlugin.getDefault().error(ARRANGE_MENU_ERROR, (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            SiriusPlugin.getDefault().error(ARRANGE_MENU_ERROR, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            SiriusPlugin.getDefault().error(ARRANGE_MENU_ERROR, (Throwable)e);
        }
    }
}

