/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.layout.provider;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramRootEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.sirius.diagram.ui.edit.api.part.AbstractDiagramElementContainerEditPart;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDiagramBorderNodeEditPart;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDiagramContainerEditPart;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDiagramElementEditPart;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDiagramListEditPart;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDiagramNameEditPart;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDiagramNodeEditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DNodeContainerViewNodeContainerCompartment2EditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DNodeContainerViewNodeContainerCompartmentEditPart;
import org.eclipse.sirius.diagram.ui.tools.api.layout.PinHelper;
import org.eclipse.sirius.diagram.ui.tools.api.layout.provider.DefaultLayoutProvider;
import org.eclipse.sirius.diagram.ui.tools.api.layout.provider.ExtendableLayoutProvider;
import org.eclipse.sirius.diagram.ui.tools.internal.layout.ArrangeAllWithAutoSize;
import org.eclipse.sirius.diagram.ui.tools.internal.layout.PinnedElementsHandler;

public class PinnedElementsLayoutProvider
extends DefaultLayoutProvider {
    private final ExtendableLayoutProvider baseProvider;
    private Predicate<Object> validateAllElementInArrayListAreIDiagramElementEditPart = new Predicate<Object>(){

        public boolean apply(Object input) {
            return input instanceof IDiagramElementEditPart;
        }
    };

    public PinnedElementsLayoutProvider(ExtendableLayoutProvider baseProvider) {
        this.baseProvider = baseProvider;
    }

    @Override
    public Command layoutEditParts(List selectedObjects, IAdaptable layoutHint) {
        HashMap initialBounds = Maps.newHashMap(this.baseProvider.getExtender().getUpdatedBounds());
        if (ArrangeAllWithAutoSize.isEnabled()) {
            this.adjustAutoSizedContainers(initialBounds);
        }
        ArrayList editParts = Lists.newArrayList((Iterable)Iterables.filter((Iterable)selectedObjects, IGraphicalEditPart.class));
        editParts.removeAll(Lists.newArrayList((Iterable)Iterables.filter((Iterable)selectedObjects, ConnectionEditPart.class)));
        CompoundCommand cc = new CompoundCommand();
        ArrayList elementstToKeepFixed = Lists.newArrayList();
        if (layoutHint.getAdapter(Collection.class) instanceof ArrayList && Iterables.all((Iterable)((ArrayList)layoutHint.getAdapter(Collection.class)), this.validateAllElementInArrayListAreIDiagramElementEditPart)) {
            elementstToKeepFixed = (ArrayList)layoutHint.getAdapter(Collection.class);
        }
        this.handlePinnedElements(editParts, initialBounds, cc, elementstToKeepFixed);
        return cc.unwrap();
    }

    private void adjustAutoSizedContainers(Map<IGraphicalEditPart, Rectangle> initialBounds) {
        PinHelper pinHelper = new PinHelper();
        for (Map.Entry<IGraphicalEditPart, Rectangle> entry : initialBounds.entrySet()) {
            AbstractDiagramElementContainerEditPart container;
            if (!(entry.getKey() instanceof AbstractDiagramElementContainerEditPart) || pinHelper.isPinned((container = (AbstractDiagramElementContainerEditPart)entry.getKey()).resolveDiagramElement())) continue;
            Rectangle bounds = entry.getValue().getCopy();
            Rectangle autoSizedBounds = container.getAutosizedDimensions();
            bounds.width = autoSizedBounds.width;
            bounds.height = autoSizedBounds.height;
            entry.setValue(bounds);
        }
    }

    private void handlePinnedElements(final Collection<IGraphicalEditPart> editParts, Map<IGraphicalEditPart, Rectangle> initialBounds, CompoundCommand cmd, ArrayList<IDiagramElementEditPart> elementstToKeepFixed) {
        for (IGraphicalEditPart part : editParts) {
            Collection<IGraphicalEditPart> children = this.getChildrenOfInterest(part);
            if (children.isEmpty()) continue;
            this.handlePinnedElements(children, initialBounds, cmd, elementstToKeepFixed);
        }
        Map initialBoundsForThisLevel = Maps.filterEntries(initialBounds, (Predicate)new Predicate<Map.Entry<IGraphicalEditPart, Rectangle>>(){

            public boolean apply(Map.Entry<IGraphicalEditPart, Rectangle> input) {
                return editParts.contains(input.getKey());
            }
        });
        PinnedElementsHandler handler = new PinnedElementsHandler(editParts, initialBoundsForThisLevel, elementstToKeepFixed);
        Map<IGraphicalEditPart, Point> newPositions = handler.computeSolution();
        for (Map.Entry<IGraphicalEditPart, Point> entry : newPositions.entrySet()) {
            IGraphicalEditPart part = entry.getKey();
            Point position = entry.getValue();
            Command cbc = this.createChangeBoundsCommand(part, position);
            cmd.add(cbc);
        }
    }

    private Collection<IGraphicalEditPart> getChildrenOfInterest(IGraphicalEditPart gep) {
        Iterable rawChildren = Iterables.filter((Iterable)gep.getChildren(), IGraphicalEditPart.class);
        Predicate invalidChildKind = Predicates.or((Predicate)Predicates.instanceOf(IDiagramBorderNodeEditPart.class), (Predicate)Predicates.instanceOf(IDiagramNameEditPart.class));
        Predicate validChildKind = Predicates.or((Predicate[])new Predicate[]{Predicates.instanceOf(IDiagramNodeEditPart.class), Predicates.instanceOf(IDiagramContainerEditPart.class), Predicates.instanceOf(IDiagramListEditPart.class)});
        Predicate isProperChild = Predicates.and((Predicate)validChildKind, (Predicate)Predicates.not((Predicate)invalidChildKind));
        ArrayList result = Lists.newArrayList((Iterable)Iterables.filter((Iterable)rawChildren, (Predicate)isProperChild));
        for (IGraphicalEditPart part : Iterables.filter((Iterable)rawChildren, (Predicate)Predicates.not((Predicate)isProperChild))) {
            if (!(part instanceof DNodeContainerViewNodeContainerCompartmentEditPart) && !(part instanceof DNodeContainerViewNodeContainerCompartment2EditPart)) continue;
            result.addAll(this.getChildrenOfInterest(part));
        }
        return result;
    }

    protected Command createChangeBoundsCommand(IGraphicalEditPart editPart, Point newPosition) {
        Command result = null;
        Request existingRequest = this.findRequest(editPart, (Object)"move");
        ChangeBoundsRequest request = null;
        double scale = 1.0;
        if (editPart.getRoot() instanceof DiagramRootEditPart) {
            ZoomManager zoomManager = ((DiagramRootEditPart)editPart.getRoot()).getZoomManager();
            scale = zoomManager.getZoom();
        }
        if (existingRequest instanceof ChangeBoundsRequest) {
            request = (ChangeBoundsRequest)existingRequest;
        } else if (existingRequest == null) {
            request = new ChangeBoundsRequest();
            request.setEditParts((EditPart)editPart);
            result = this.buildCommandWrapper((Request)request, (EditPart)editPart);
        }
        if (newPosition != null) {
            Dimension delta = newPosition.getDifference(editPart.getFigure().getBounds().getLocation());
            delta.width = (int)((double)delta.width * scale);
            delta.height = (int)((double)delta.height * scale);
            if (request != null) {
                request.setMoveDelta(new Point(delta.width, delta.height));
                request.setLocation(newPosition);
                request.setType((Object)"move");
            } else {
                return null;
            }
        }
        return result;
    }
}

