/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.graphical.edit.policies;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ImageFigure;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.LayerConstants;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.DiagramAssistantEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.sirius.business.api.query.IdentifiedElementQuery;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.common.tools.api.util.EqualityHelper;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.business.api.componentization.DiagramComponentizationManager;
import org.eclipse.sirius.diagram.description.AdditionalLayer;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.diagram.description.Layer;
import org.eclipse.sirius.diagram.description.filter.FilterDescription;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.sirius.diagram.ui.tools.internal.commands.ChangeLayerActivationCommand;
import org.eclipse.sirius.diagram.ui.tools.internal.figure.DropDownMenuFigure;
import org.eclipse.sirius.diagram.ui.tools.internal.figure.PopupBarFigure;
import org.eclipse.sirius.diagram.ui.tools.internal.handler.ChangeFilterActivation;
import org.eclipse.sirius.viewpoint.description.IdentifiedElement;
import org.eclipse.sirius.viewpoint.provider.SiriusEditPlugin;

public class MyNiceCustomBarPolicy
extends DiagramAssistantEditPolicy
implements LayerConstants {
    private static final ImageDescriptor DESC_LAYER = DiagramUIPlugin.Implementation.getBundledImageDescriptor("icons/layers.gif");
    private static final ImageDescriptor DESC_FILTER = DiagramUIPlugin.Implementation.getBundledImageDescriptor("icons/filters.gif");
    private static final ImageDescriptor DESC_ACTIVE_LAYER = DiagramUIPlugin.Implementation.getBundledImageDescriptor("/icons/layer_active.gif");
    private static final ImageDescriptor DESC_INACTIVE_LAYER = DiagramUIPlugin.Implementation.getBundledImageDescriptor("/icons/layer_inactive.gif");
    private static final ImageDescriptor DESC_ACTIVE_FILTER = DiagramUIPlugin.Implementation.getBundledImageDescriptor("/icons/layer_active.gif");
    private static final ImageDescriptor DESC_INACTIVE_FILTER = DiagramUIPlugin.Implementation.getBundledImageDescriptor("/icons/layer_inactive.gif");
    private IFigure layer;
    private final List<IFigure> figures = new ArrayList<IFigure>();
    private PopupBarFigure toolBar;

    protected void hideDiagramAssistant() {
        for (IFigure figure : this.figures) {
            this.layer.remove(figure);
        }
        this.figures.clear();
    }

    protected boolean isDiagramAssistant(Object object) {
        return this.figures.contains(object);
    }

    protected int getDisappearanceDelay() {
        return 1000;
    }

    protected boolean isDiagramAssistantShowing() {
        return !this.figures.isEmpty();
    }

    protected void showDiagramAssistant(Point referencePoint) {
        if (this.getMouseLocation() == null) {
            return;
        }
        this.translateToAbsoluteMouseLocation();
        this.layer = this.getLayer("Handle Layer");
        FreeformLayer composite = new FreeformLayer();
        composite.setSize(80, 100);
        composite.setLocation(this.getMouseLocation().getCopy().getTranslated(15, 15));
        this.toolBar = new PopupBarFigure((IFigure)composite);
        DropDownMenuFigure dropMenu = this.createDropDownMenuFigure((IFigure)composite, DESC_LAYER);
        this.fillWithLayers(dropMenu);
        DropDownMenuFigure dropMenu2 = this.createDropDownMenuFigure((IFigure)composite, DESC_FILTER);
        this.fillWithFilters(dropMenu2);
        this.figures.add((IFigure)composite);
        this.layer.add((IFigure)composite);
    }

    private void translateToAbsoluteMouseLocation() {
        this.getHostFigure().translateToAbsolute((Translatable)this.getMouseLocation());
        IFigure parentFigure = this.getHostFigure().getParent();
        while (parentFigure != null) {
            if (parentFigure instanceof Viewport) {
                Viewport viewport = (Viewport)parentFigure;
                this.getMouseLocation().translate(viewport.getHorizontalRangeModel().getValue(), viewport.getVerticalRangeModel().getValue());
                parentFigure = parentFigure.getParent();
                continue;
            }
            parentFigure = parentFigure.getParent();
        }
    }

    private DropDownMenuFigure createDropDownMenuFigure(IFigure parent, ImageDescriptor desc) {
        DropDownMenuFigure dropMenu = new DropDownMenuFigure(new ImageFigure(SiriusEditPlugin.getPlugin().getImage(desc)), parent);
        dropMenu.addMouseMotionListener((MouseMotionListener)new MouseMotionListener.Stub(){

            public void mouseExited(MouseEvent me) {
                MyNiceCustomBarPolicy.this.setMouseLocation(null);
                MyNiceCustomBarPolicy.this.setAvoidHidingDiagramAssistant(false);
            }

            public void mouseEntered(MouseEvent me) {
                MyNiceCustomBarPolicy.this.setMouseLocation(me.getLocation());
                MyNiceCustomBarPolicy.this.setAvoidHidingDiagramAssistant(true);
            }
        });
        this.toolBar.addToMenu((IFigure)dropMenu);
        return dropMenu;
    }

    private void fillWithLayers(DropDownMenuFigure dropMenu) {
        final DDiagram dDiagram = this.getCurrentDiagram();
        DiagramDescription desc = dDiagram.getDescription();
        Session session = SessionManager.INSTANCE.getSession(((DSemanticDiagram)dDiagram).getTarget());
        Iterable additionalLayers = Iterables.filter((Iterable)new DiagramComponentizationManager().getAllLayers(session.getSelectedViewpoints(false), desc), AdditionalLayer.class);
        for (final AdditionalLayer additionalLayer : additionalLayers) {
            if (!additionalLayer.isOptional()) continue;
            boolean activated = EqualityHelper.contains((Collection)dDiagram.getActivatedLayers(), (EObject)additionalLayer);
            ImageDescriptor imgDesc = activated ? DESC_ACTIVE_LAYER : DESC_INACTIVE_LAYER;
            dropMenu.addToMenu(SiriusEditPlugin.getPlugin().getImage(imgDesc), new IdentifiedElementQuery((IdentifiedElement)additionalLayer).getLabel(), new Runnable(){

                @Override
                public void run() {
                    MyNiceCustomBarPolicy.this.hideDiagramAssistant();
                    TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)dDiagram);
                    ChangeLayerActivationCommand changeActivatedLayersCmd = new ChangeLayerActivationCommand(domain, dDiagram, (Layer)additionalLayer, (IProgressMonitor)new NullProgressMonitor());
                    domain.getCommandStack().execute((Command)changeActivatedLayersCmd);
                }
            });
        }
        dropMenu.updateFigure();
    }

    private void fillWithFilters(DropDownMenuFigure dropMenu) {
        final DDiagram diagram = this.getCurrentDiagram();
        DiagramDescription desc = diagram.getDescription();
        EList filters = desc.getFilters();
        for (final FilterDescription filter : filters) {
            final boolean activated = EqualityHelper.contains((Collection)diagram.getActivatedFilters(), (EObject)filter);
            ImageDescriptor imgDesc = activated ? DESC_ACTIVE_FILTER : DESC_INACTIVE_FILTER;
            dropMenu.addToMenu(SiriusEditPlugin.getPlugin().getImage(imgDesc), filter.getName(), new Runnable(){

                @Override
                public void run() {
                    MyNiceCustomBarPolicy.this.hideDiagramAssistant();
                    ChangeFilterActivation change = new ChangeFilterActivation(MyNiceCustomBarPolicy.this.getPart(), diagram, filter, !activated);
                    change.run();
                }
            });
        }
        dropMenu.updateFigure();
    }

    private IDiagramWorkbenchPart getPart() {
        IAdaptable editor = (IAdaptable)this.getHost().getViewer().getProperty("org.eclipse.sirius.diagram.ui.part.SiriusDiagramEditorID");
        IDiagramWorkbenchPart part = (IDiagramWorkbenchPart)editor.getAdapter(IDiagramWorkbenchPart.class);
        return part;
    }

    private DDiagram getCurrentDiagram() {
        Object model = this.getHost().getModel();
        DDiagram result = null;
        if (model instanceof View) {
            EObject element = ((View)model).getElement();
            if (element instanceof DDiagram) {
                result = (DDiagram)element;
            } else if (element instanceof DDiagramElement) {
                result = ((DDiagramElement)element).getParentDiagram();
            }
        }
        return result;
    }

    public void activate() {
        ((IGraphicalEditPart)this.getHost()).getFigure().addMouseMotionListener((MouseMotionListener)this);
    }

    public void deactivate() {
        ((IGraphicalEditPart)this.getHost()).getFigure().removeMouseMotionListener((MouseMotionListener)this);
        this.hideDiagramAssistant();
    }
}

