/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.editor.tabbar.actions;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gmf.runtime.common.ui.action.ActionMenuManager;
import org.eclipse.gmf.runtime.common.ui.action.IDisposableAction;
import org.eclipse.gmf.runtime.diagram.ui.actions.internal.ArrangeAction;
import org.eclipse.gmf.runtime.diagram.ui.actions.internal.ArrangeMenuManager;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart;
import org.eclipse.gmf.runtime.diagram.ui.services.layout.AbstractLayoutEditPartProvider;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DDiagramEditPart;
import org.eclipse.sirius.diagram.ui.tools.internal.actions.layout.ArrangeBorderedNodesAction;
import org.eclipse.sirius.diagram.ui.tools.internal.layout.provider.ArrangeAllOnlyLayoutProvider;
import org.eclipse.sirius.diagram.ui.tools.internal.layout.provider.LayoutService;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;

public class TabbarArrangeMenuManager
extends ArrangeMenuManager
implements ISelectionListener {
    private IWorkbenchPage page;
    private IWorkbenchPart representationPart;
    private ISelection currentSelection;
    private ArrangeAction toolbarArrangeSelectionAction;
    private ArrangeAction toolbarArrangeAllAction;
    private ArrangeBorderedNodesAction toolBarArrangeBorderedNodesAction;

    public TabbarArrangeMenuManager(IWorkbenchPage page, IDiagramWorkbenchPart iDiagramWorkbenchPart) {
        this.page = page;
        this.representationPart = iDiagramWorkbenchPart;
        page.addSelectionListener((ISelectionListener)this);
    }

    public void add(IAction action) {
        super.add(action);
        if (action instanceof IDisposableAction) {
            ((IDisposableAction)action).init();
        }
    }

    protected void itemRemoved(IContributionItem item) {
        IAction action;
        if (item instanceof ActionContributionItem && (action = ((ActionContributionItem)item).getAction()) instanceof IDisposableAction) {
            ((IDisposableAction)action).dispose();
        }
    }

    public void dispose() {
        this.currentSelection = null;
        if (this.page != null) {
            this.page.removeSelectionListener((ISelectionListener)this);
            this.page = null;
        }
        this.removeAll();
        this.toolbarArrangeAllAction = null;
        this.toolBarArrangeBorderedNodesAction = null;
        this.toolbarArrangeSelectionAction = null;
        this.representationPart = null;
        super.dispose();
    }

    public void setDefaultAction(String actionId) {
        IContributionItem[] iContributionItemArray = this.getItems();
        int n = iContributionItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            IContributionItem item = iContributionItemArray[n2];
            if (item instanceof ActionContributionItem && actionId.equals(((ActionContributionItem)item).getAction().getId())) {
                IAction defaultAction = ((ActionContributionItem)item).getAction();
                this.setHandler(defaultAction);
                super.setDefaultAction(defaultAction);
                return;
            }
            ++n2;
        }
    }

    private void setHandler(IAction defaultAction) {
        try {
            Method method = ActionMenuManager.MenuCreatorAction.class.getDeclaredMethod("setActionHandler", IAction.class);
            method.setAccessible(true);
            method.invoke((Object)this.action, defaultAction);
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {}
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (this.representationPart != null && this.representationPart.equals(part) && (this.currentSelection == null || this.currentSelection != null && !this.currentSelection.equals(selection))) {
            this.currentSelection = selection;
            this.refreshArrangeMenu(this.currentSelection);
        }
    }

    private void refreshArrangeMenu(ISelection selection) {
        Object firstElement;
        boolean arrangeSelection = false;
        if (selection instanceof IStructuredSelection && (firstElement = ((IStructuredSelection)selection).getFirstElement()) instanceof IGraphicalEditPart && !(firstElement instanceof DDiagramEditPart)) {
            arrangeSelection = true;
        }
        if (arrangeSelection) {
            this.cleanArrangeDiagram();
            if (this.find("toolbarArrangeSelectionAction") == null) {
                this.toolbarArrangeSelectionAction = ArrangeAction.createToolbarArrangeSelectionAction((IWorkbenchPage)this.page);
                this.add((IAction)this.toolbarArrangeSelectionAction);
            }
            this.disableArrangeSelectionIfNotSupported(this.toolbarArrangeSelectionAction, (IStructuredSelection)selection);
            this.setDefaultAction(this.toolbarArrangeSelectionAction.getId());
        } else {
            this.addDefaultArrangeActions();
        }
    }

    private void addDefaultArrangeActions() {
        this.cleanArrangeDDiagramElement();
        if (this.find("toolbarArrangeAllAction") == null) {
            this.toolbarArrangeAllAction = ArrangeAction.createToolbarArrangeAllAction((IWorkbenchPage)this.page);
            this.add((IAction)this.toolbarArrangeAllAction);
        }
        if (this.find("arrangeBorderedNodesActionToolBar") == null) {
            this.toolBarArrangeBorderedNodesAction = ArrangeBorderedNodesAction.createToolBarArrangeBorderedNodesAction(this.page);
            this.add((IAction)this.toolBarArrangeBorderedNodesAction);
        }
        this.setDefaultAction(this.toolbarArrangeAllAction.getId());
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (this.isEmpty() && visible && this.page != null) {
            this.refreshArrangeMenu(this.page.getSelection());
        }
    }

    private void cleanArrangeDDiagramElement() {
        if (this.toolbarArrangeSelectionAction != null) {
            this.remove(this.toolbarArrangeSelectionAction.getId());
            this.toolbarArrangeSelectionAction = null;
        }
    }

    private void cleanArrangeDiagram() {
        if (this.toolbarArrangeAllAction != null) {
            this.remove(this.toolbarArrangeAllAction.getId());
            this.toolbarArrangeAllAction = null;
        }
        if (this.toolBarArrangeBorderedNodesAction != null) {
            this.remove(this.toolBarArrangeBorderedNodesAction.getId());
            this.toolBarArrangeBorderedNodesAction = null;
        }
    }

    private void disableArrangeSelectionIfNotSupported(ArrangeAction createToolbarArrangeSelectionAction, IStructuredSelection selection) {
        IGraphicalEditPart diagramEditPart;
        AbstractLayoutEditPartProvider layoutNodeProvider;
        RootEditPart root;
        IGraphicalEditPart graphicalElement = null;
        Iterator iterator = selection.iterator();
        while (iterator.hasNext() && graphicalElement == null) {
            Object next = iterator.next();
            if (!(next instanceof IGraphicalEditPart)) continue;
            graphicalElement = (IGraphicalEditPart)next;
            break;
        }
        if (graphicalElement != null && graphicalElement.isActive() && graphicalElement.getRoot() != null && !(root = graphicalElement.getRoot()).getChildren().isEmpty() && root.getChildren().iterator().next() instanceof IGraphicalEditPart && (layoutNodeProvider = LayoutService.getProvider(diagramEditPart = (IGraphicalEditPart)root.getChildren().iterator().next()).getLayoutNodeProvider(diagramEditPart)) instanceof ArrangeAllOnlyLayoutProvider) {
            createToolbarArrangeSelectionAction.setEnabled(false);
        }
    }
}

