/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.editor.tabbar;

import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.actions.DiagramAction;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.sirius.common.ui.tools.api.util.EclipseUIUtil;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.business.api.diagramtype.DiagramTypeDescriptorRegistry;
import org.eclipse.sirius.diagram.business.api.diagramtype.IDiagramTypeDescriptor;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDDiagramEditPart;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.part.EditorActionBarContributor;

public class LayoutingModeSwitchingAction
extends DiagramAction {
    private static final String MESSAGE_ACTIVATE_LAYOUTING_MODE = "Activate Layouting Mode";
    private static final String MESSAGE_DEACTIVATE_LAYOUTING_MODE = "Deactivate Layouting Mode";
    private static final String MESSAGE_STATUS_LINE_LAYOUTING_MODE_IS_ON = "Layouting Mode";
    private static final String MESSAGE_STATUS_LINE_LAYOUTING_MODE_IS_OFF = "";
    private static final ImageDescriptor ACTIVATE_LAYOUTING_MODE_IMAGE_DESCRIPTOR = DiagramUIPlugin.Implementation.getBundledImageDescriptor("icons/layoutingMode_activate.png");
    private DDiagram ddiagram;

    public LayoutingModeSwitchingAction(IWorkbenchPage workbenchPage, DDiagram editorDiagram) {
        super(workbenchPage);
        this.setId("switchLayoutingMode");
        this.ddiagram = editorDiagram;
        this.setImageDescriptor(ACTIVATE_LAYOUTING_MODE_IMAGE_DESCRIPTOR);
        this.setTextAndStatusAccordingToLayoutingMode();
    }

    private void setTextAndStatusAccordingToLayoutingMode() {
        if (this.ddiagram != null && this.ddiagram.isIsInLayoutingMode()) {
            this.setText(MESSAGE_DEACTIVATE_LAYOUTING_MODE);
            this.setChecked(true);
        } else {
            this.setText(MESSAGE_ACTIVATE_LAYOUTING_MODE);
            this.setChecked(false);
        }
        IEditorPart activeEditor = EclipseUIUtil.getActiveEditor();
        if (activeEditor != null) {
            IEditorSite site = (IEditorSite)activeEditor.getSite();
            EditorActionBarContributor actionBarContributor = null;
            IStatusLineManager statusLineManager = null;
            if (site != null && site.getActionBarContributor() instanceof EditorActionBarContributor) {
                actionBarContributor = (EditorActionBarContributor)site.getActionBarContributor();
            }
            if (actionBarContributor != null && actionBarContributor.getActionBars() != null) {
                statusLineManager = actionBarContributor.getActionBars().getStatusLineManager();
            }
            if (statusLineManager != null) {
                if (this.ddiagram != null && this.ddiagram.isIsInLayoutingMode()) {
                    String statusMessage = MESSAGE_STATUS_LINE_LAYOUTING_MODE_IS_ON;
                    statusLineManager.setMessage(DiagramUIPlugin.getPlugin().getImage(ACTIVATE_LAYOUTING_MODE_IMAGE_DESCRIPTOR), statusMessage);
                } else {
                    statusLineManager.setMessage(MESSAGE_STATUS_LINE_LAYOUTING_MODE_IS_OFF);
                }
            }
        }
    }

    public int getStyle() {
        return 2;
    }

    protected boolean isSelectionListener() {
        return false;
    }

    protected Command getCommand() {
        Diagram diagramGMF;
        IDDiagramEditPart diagramEP;
        UnexecutableCommand returnedCommand = UnexecutableCommand.INSTANCE;
        List selectedObjects = this.getSelectedObjects();
        if (!selectedObjects.isEmpty() && selectedObjects.iterator().next() instanceof IDDiagramEditPart && (diagramEP = (IDDiagramEditPart)selectedObjects.iterator().next()).getModel() instanceof Diagram && (diagramGMF = (Diagram)diagramEP.getModel()).getElement() instanceof DDiagram) {
            returnedCommand = this.getCommandForDDiagram((DDiagram)diagramGMF.getElement());
        }
        return returnedCommand;
    }

    private Command getCommandForDDiagram(DDiagram diagram) {
        UnexecutableCommand returnedCommand = UnexecutableCommand.INSTANCE;
        TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)diagram);
        if (editingDomain != null) {
            returnedCommand = new ICommandProxy((ICommand)new SetLayoutingModeCommandAndUpdateActionImage(editingDomain, diagram, !diagram.isIsInLayoutingMode()));
        }
        return returnedCommand;
    }

    public void dispose() {
        this.ddiagram = null;
        super.dispose();
    }

    public static boolean diagramAllowsLayoutingMode(DDiagram diagram) {
        if (diagram == null || diagram.getDescription() == null) {
            return false;
        }
        boolean diagramAllowsLayoutingMode = true;
        for (IDiagramTypeDescriptor diagramTypeDescriptor : DiagramTypeDescriptorRegistry.getInstance().getAllDiagramTypeDescriptors()) {
            if (!diagramTypeDescriptor.getDiagramDescriptionProvider().handles(diagram.getDescription().eClass().getEPackage())) continue;
            diagramAllowsLayoutingMode = diagramAllowsLayoutingMode && diagramTypeDescriptor.getDiagramDescriptionProvider().allowsLayoutingModeActivation();
            break;
        }
        return diagramAllowsLayoutingMode;
    }

    protected Request createTargetRequest() {
        return null;
    }

    public class SetLayoutingModeCommandAndUpdateActionImage
    extends AbstractTransactionalCommand {
        private DDiagram diagram;
        private boolean layoutingModeShouldBeEnabled;

        public SetLayoutingModeCommandAndUpdateActionImage(TransactionalEditingDomain editingDomain, DDiagram diagram, boolean layoutingModeShouldBeEnabled) {
            super(editingDomain, "Activating Layouting mode", null);
            this.diagram = diagram;
            this.layoutingModeShouldBeEnabled = layoutingModeShouldBeEnabled;
            if (this.diagram.isIsInLayoutingMode()) {
                LayoutingModeSwitchingAction.this.setText("Deactivating  Layouting mode");
            }
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            CommandResult commandResult = CommandResult.newOKCommandResult();
            if (LayoutingModeSwitchingAction.diagramAllowsLayoutingMode(this.diagram)) {
                this.diagram.setIsInLayoutingMode(this.layoutingModeShouldBeEnabled);
                LayoutingModeSwitchingAction.this.setTextAndStatusAccordingToLayoutingMode();
            }
            return commandResult;
        }
    }
}

