/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.commands.emf;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.CopyToClipboardCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.diagram.ui.tools.internal.clipboard.SiriusClipboardManager;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;

public class CopyToSiriusClipboardCommand
extends RecordingCommand
implements AbstractCommand.NonDirtying {
    private final Collection<DSemanticDecorator> dElementsToCopy = Sets.newHashSet();
    private final Collection<EObject> elementsToCopy = Sets.newHashSet();
    private final TransactionalEditingDomain domain;
    private Command copyCommand;

    public CopyToSiriusClipboardCommand(TransactionalEditingDomain domain, Collection<DSemanticDecorator> dElements, Collection<EObject> semanticElements) {
        super(domain, "Copy to clipboard");
        this.domain = domain;
        this.dElementsToCopy.addAll(dElements);
        this.elementsToCopy.addAll(semanticElements);
    }

    public Collection<?> getSourceObjects() {
        return Lists.newArrayList((Iterable)Iterables.concat(this.dElementsToCopy, this.elementsToCopy));
    }

    protected boolean prepare() {
        if (!this.getSourceObjects().isEmpty()) {
            this.copyCommand = CopyToClipboardCommand.create((EditingDomain)this.domain, this.getSourceObjects());
        }
        return this.copyCommand != null ? this.copyCommand.canExecute() : true;
    }

    public void doExecute() {
        if (this.copyCommand != null) {
            this.copyCommand.execute();
        } else {
            this.domain.setClipboard(null);
        }
        SiriusClipboardManager.getInstance().setSiriusClipboard(this.domain);
    }

    public String toString() {
        return this.copyCommand.toString();
    }
}

